/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.services.upload;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.services.upload.Uploader;
import com.hummer.im._internals.services.upload.YYaliOSS.AliOSS;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.service.UploadService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UploadServiceImp
implements ServiceProvider.Service,
UploadService {
    private static final String TAG = "UploadServiceImp";
    private static Uploader mUploader;
    private Map<String, UploadTask> tasks = new HashMap<String, UploadTask>();

    @Override
    public Class[] staticDependencies() {
        return null;
    }

    @Override
    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class};
    }

    @Override
    public Class[] plantingDynamicDependencies() {
        return new Class[0];
    }

    @Override
    public void initService() {
    }

    @Override
    public void openService(@NonNull RichCompletion richCompletion) {
        this.registerUploader(new AliOSS());
        CompletionUtils.dispatchSuccess(richCompletion);
    }

    @Override
    public void closeService() {
    }

    @Override
    public void registerUploader(@NonNull Uploader uploader) {
        mUploader = uploader;
    }

    @Override
    public Uploader getUploader() {
        return mUploader;
    }

    @Override
    public void uploadFile(final @NonNull String string, final @NonNull Uploader.UploadCallback<String> uploadCallback) {
        HMRContext.work.async("UploadServiceImp::uploadFile", new Runnable(){

            @Override
            public void run() {
                UploadTask uploadTask = (UploadTask)UploadServiceImp.this.tasks.get(string);
                if (uploadTask == null) {
                    Log.i(UploadServiceImp.TAG, Trace.once().method("uploadFile").msg("New task").info("path", string));
                    uploadTask = new UploadTask(string);
                    UploadServiceImp.this.tasks.put(string, uploadTask);
                    uploadTask.callbacks.add(uploadCallback);
                    final UploadTask uploadTask2 = uploadTask;
                    mUploader.uploadFile(string, new Uploader.UploadCallback<String>(){

                        @Override
                        public void onProgress(float f) {
                            uploadTask2.notifyProgress(f);
                        }

                        @Override
                        public void onSuccess(String string) {
                            uploadTask2.notifySuccess(string);
                            UploadServiceImp.this.tasks.remove(string);
                        }

                        @Override
                        public void onFailure(Error error) {
                            uploadTask2.notifyFailed(error);
                            UploadServiceImp.this.tasks.remove(string);
                        }
                    });
                } else {
                    Log.i(UploadServiceImp.TAG, Trace.once().method("uploadFile").msg("Existed task").info("path", string));
                    uploadTask.callbacks.add(uploadCallback);
                }
            }
        });
    }

    @Override
    public void cancelUploadFile(String string) {
        UploadTask uploadTask = this.tasks.get(string);
        if (uploadTask == null) {
            return;
        }
        mUploader.cancelUploadFile(string);
    }

    private static final class UploadTask {
        String path;
        Set<Uploader.UploadCallback<String>> callbacks = new HashSet<Uploader.UploadCallback<String>>();

        UploadTask(String string) {
            this.path = string;
        }

        void notifyProgress(float f) {
            for (Uploader.UploadCallback<String> uploadCallback : this.callbacks) {
                uploadCallback.onProgress(f);
            }
        }

        void notifySuccess(String string) {
            for (Uploader.UploadCallback<String> uploadCallback : this.callbacks) {
                uploadCallback.onSuccess(string);
            }
        }

        void notifyFailed(Error error) {
            for (Uploader.UploadCallback<String> uploadCallback : this.callbacks) {
                uploadCallback.onFailure(error);
            }
        }
    }
}

