/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.log.trace;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.hummer.im._internals.log.trace.StackTraceInfo;
import com.hummer.im._internals.shared.LogId;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public final class Trace {
    private final List<String> parameters = new LinkedList<String>();
    private String methodName;
    private String message;
    private Long flowElapsed = null;
    private String flowName = null;

    public static Trace once() {
        return new Trace(StackTraceInfo.getInvokingMethodName());
    }

    public static Trace once(String string, Object ... objectArray) {
        return new Trace(StackTraceInfo.getInvokingMethodName()).msg(string, objectArray);
    }

    public static Trace once(Object object) {
        return new Trace(StackTraceInfo.getInvokingMethodName()).msg(object == null ? "null" : object.toString());
    }

    public Trace msg(String string, Object ... objectArray) {
        this.message = String.format(Locale.US, string, objectArray);
        return this;
    }

    public Trace msg(Object object) {
        this.message = object == null ? "null" : object.toString();
        return this;
    }

    public Trace method(@NonNull String string) {
        this.methodName = string;
        return this;
    }

    public Trace info(String string, Object object) {
        this.parameters.add(string + ":" + object);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.flowName != null) {
            stringBuilder.append(String.format(Locale.US, "[%s]", this.flowName));
        }
        stringBuilder.append(this.methodName);
        if (this.flowElapsed != null && this.flowElapsed >= 10L) {
            stringBuilder.append("(");
            stringBuilder.append(this.flowElapsed);
            stringBuilder.append("ms)");
        }
        if (this.message != null || this.parameters.size() > 0) {
            stringBuilder.append(" |");
        }
        if (this.message != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.message);
        }
        if (this.parameters.size() > 0) {
            stringBuilder.append(" {");
            stringBuilder.append(TextUtils.join((CharSequence)", ", this.parameters));
            stringBuilder.append("}");
        }
        this.parameters.clear();
        this.message = null;
        return stringBuilder.toString();
    }

    private Trace(String string) {
        this.methodName = string;
    }

    private Trace asFlow(String string, Long l) {
        this.flowName = string;
        this.flowElapsed = l;
        return this;
    }

    public static class Flow {
        public final long logId;
        private final String name;
        private final ArrayList<Long> timestamps = new ArrayList();

        public Flow() {
            this.logId = LogId.generate();
            this.name = String.format(Locale.US, "%-19d", this.logId);
        }

        public Trace trace() {
            return new Trace(StackTraceInfo.getInvokingMethodName()).asFlow(this.name, this.getIntervalByAdvancingTimestamp());
        }

        public Trace trace(String string, Object ... objectArray) {
            return new Trace(StackTraceInfo.getInvokingMethodName()).asFlow(this.name, this.getIntervalByAdvancingTimestamp()).msg(string, objectArray);
        }

        public Trace trace(Object object) {
            return new Trace(StackTraceInfo.getInvokingMethodName()).asFlow(this.name, this.getIntervalByAdvancingTimestamp()).msg(object == null ? "null" : object.toString());
        }

        private Long getIntervalByAdvancingTimestamp() {
            Long l = System.currentTimeMillis();
            Long l2 = null;
            if (this.timestamps.size() >= 1) {
                Long l3 = this.timestamps.get(this.timestamps.size() - 1);
                l2 = l - l3;
            }
            this.timestamps.add(l);
            return l2;
        }
    }
}

