/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.chatsvc;

import com.google.protobuf.ByteString;
import com.hummer.im.HMR;
import com.hummer.im._internals.chatsvc.IdentifiableHelper;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.Chat;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.proto.Notify;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.PushContent;
import com.hummer.im.model.chat.contents.Notification;
import com.hummer.im.model.chat.states.Archived;
import com.hummer.im.model.chat.states.Revoked;
import com.hummer.im.model.id.Group;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;

public class MessageParser {
    public static final String TAG = "ChatService";

    public static Message parseContent(ByteString byteString, long l, Im.Action action) {
        try {
            if (action == Im.Action.kP2PChat) {
                return MessageParser.parseP2PMessage(byteString, l);
            }
            if (action == Im.Action.kFanoutAppSessionChat) {
                return MessageParser.parseFanoutMessage(byteString, l);
            }
            if (action == Im.Action.kRevokeAppSessionChat) {
                return MessageParser.parseRevokedMessage(byteString, l);
            }
            if (action == Im.Action.kMultiCastAppSessionChat) {
                return MessageParser.parseMultiCastMessage(byteString, l);
            }
            if (action == Im.Action.kChatMessageModified) {
                return MessageParser.parseMessageModified(byteString, l);
            }
            if (action == Im.Action.kBatchP2PChat) {
                return MessageParser.parseBatchP2PMessage(byteString, l);
            }
            if (action == Im.Action.kMultiCastP2PChat) {
                return MessageParser.parseMultiCastP2PMessage(byteString, l);
            }
            if (action == Im.Action.kModifyAppSessionChat) {
                return MessageParser.parseModifyAppSessionMessage(byteString, l);
            }
            if (action == Im.Action.kBatchAppSessionChat) {
                return MessageParser.parseBatchAppSessionMessage(byteString, l);
            }
            if (action == Im.Action.kBroadCastAppSessionChat) {
                return MessageParser.parseBroadCastAppSessionMessage(byteString, l);
            }
            if (action == Im.Action.kBatchNotify) {
                return MessageParser.parseBatchNotification(byteString, l);
            }
            if (action == Im.Action.kGroupNotify) {
                return MessageParser.parseGroupNotification(byteString, l);
            }
            if (action == Im.Action.kInsertChatHistory) {
                return MessageParser.parseInsertChatHistory(byteString, l);
            }
        }
        catch (Throwable throwable) {
            Log.e(TAG, Trace.once().method("parse").info("action", (Object)action).info("msg", byteString).info("exception", throwable.getMessage()));
        }
        return null;
    }

    private static Message parseP2PMessage(ByteString byteString, long l) {
        Chat.P2PChatRequest p2PChatRequest = (Chat.P2PChatRequest)((Chat.P2PChatRequest.Builder)Chat.P2PChatRequest.newBuilder().mergeFrom(byteString)).build();
        Content content = Content.makeContent(p2PChatRequest.getMsgType(), p2PChatRequest.getContent().toByteArray());
        if (content == null) {
            Log.e(TAG, Trace.once().method("parseP2PMessage").msg("Unrecognized content").info("msgType", p2PChatRequest.getMsgType()).info("content", p2PChatRequest.getContent()));
            return null;
        }
        Message message = new Message();
        User user = new User(p2PChatRequest.getToUid());
        String string = p2PChatRequest.getExtension();
        if ("".equals(string)) {
            string = null;
        }
        message.setContent(content);
        message.setSender(new User(p2PChatRequest.getFromUid()));
        message.setReceiver(user);
        message.setPushContent(MessageParser.parsePushContent(p2PChatRequest.getOsPushMsg()));
        message.setUuid(p2PChatRequest.getUuid());
        message.setTimestamp(l);
        message.setState(new Archived());
        message.setAppExtra(string);
        return message;
    }

    private static Message parseFanoutMessage(ByteString byteString, long l) {
        Chat.FanoutAppSessionChatRequest fanoutAppSessionChatRequest = (Chat.FanoutAppSessionChatRequest)((Chat.FanoutAppSessionChatRequest.Builder)Chat.FanoutAppSessionChatRequest.newBuilder().mergeFrom(byteString)).build();
        Content content = Content.makeContent(fanoutAppSessionChatRequest.getMsgType(), fanoutAppSessionChatRequest.getContent().toByteArray());
        if (content == null) {
            Log.e(TAG, Trace.once().method("parseFanoutMessage").msg("Unrecognized content").info("msgType", fanoutAppSessionChatRequest.getMsgType()).info("content", fanoutAppSessionChatRequest.getContent()));
            return null;
        }
        Message message = new Message();
        message.setContent(content);
        Identifiable identifiable = IdentifiableHelper.makeIdentifiable(fanoutAppSessionChatRequest.getFromIdType(), fanoutAppSessionChatRequest.getFromId());
        Identifiable identifiable2 = IdentifiableHelper.makeIdentifiable(fanoutAppSessionChatRequest.getToIdType(), fanoutAppSessionChatRequest.getToId());
        if (identifiable == null || identifiable2 == null) {
            Log.w(TAG, Trace.once().method("parseFanoutMessage").msg("Unrecognized sender/receiver").info("sender", fanoutAppSessionChatRequest.getFromIdType()).info("receiver", fanoutAppSessionChatRequest.getToIdType()));
        }
        message.setSender(identifiable);
        message.setReceiver(identifiable2);
        message.setPushContent(MessageParser.parsePushContent(fanoutAppSessionChatRequest.hasOsPushMsg() ? fanoutAppSessionChatRequest.getOsPushMsg() : null));
        message.setUuid(fanoutAppSessionChatRequest.getUuid());
        message.setTimestamp(l);
        message.setState(new Archived());
        return message;
    }

    private static Message parseRevokedMessage(ByteString byteString, long l) {
        Chat.RevokeAppSessionChatRequest revokeAppSessionChatRequest = (Chat.RevokeAppSessionChatRequest)((Chat.RevokeAppSessionChatRequest.Builder)Chat.RevokeAppSessionChatRequest.newBuilder().mergeFrom(byteString)).build();
        Identifiable identifiable = IdentifiableHelper.makeIdentifiable(revokeAppSessionChatRequest.getFromIdType(), revokeAppSessionChatRequest.getFromId());
        Identifiable identifiable2 = IdentifiableHelper.makeIdentifiable(revokeAppSessionChatRequest.getToIdType(), revokeAppSessionChatRequest.getToId());
        if (identifiable2 == null) {
            Log.w(TAG, Trace.once().method("parseRevokedMessage").msg("Unrecognized receiver").info("receiver", revokeAppSessionChatRequest.getToIdType()));
            return null;
        }
        Message message = new Message();
        message.setAppExtra(revokeAppSessionChatRequest.getExtra());
        message.setSender(identifiable);
        message.setReceiver(identifiable2);
        message.setTimestamp(revokeAppSessionChatRequest.getTimestamp());
        message.setUuid(revokeAppSessionChatRequest.getUuid());
        message.setState(new Revoked());
        return message;
    }

    private static Message parseMultiCastMessage(ByteString byteString, long l) {
        Chat.MultiCastAppSessionChatRequest multiCastAppSessionChatRequest = (Chat.MultiCastAppSessionChatRequest)((Chat.MultiCastAppSessionChatRequest.Builder)Chat.MultiCastAppSessionChatRequest.newBuilder().mergeFrom(byteString)).build();
        Content content = Content.makeContent(multiCastAppSessionChatRequest.getMsgType(), multiCastAppSessionChatRequest.getContent().toByteArray());
        if (content == null) {
            Log.e(TAG, Trace.once().method("parseMultiCastMessage").msg("Unrecognized content").info("msgType", multiCastAppSessionChatRequest.getMsgType()).info("content", multiCastAppSessionChatRequest.getContent()));
            return null;
        }
        Identifiable identifiable = IdentifiableHelper.makeIdentifiable(multiCastAppSessionChatRequest.getFromIdType(), multiCastAppSessionChatRequest.getFromId());
        Identifiable identifiable2 = IdentifiableHelper.makeIdentifiable(multiCastAppSessionChatRequest.getToIdType(), multiCastAppSessionChatRequest.getToId());
        if (identifiable == null || identifiable2 == null) {
            Log.w(TAG, Trace.once().method("parseMultiCasMessage").msg("Unrecognized sender/receiver").info("sender", multiCastAppSessionChatRequest.getFromIdType()).info("receiver", multiCastAppSessionChatRequest.getToIdType()));
            return null;
        }
        Message message = new Message();
        message.setContent(content);
        message.setSender(identifiable);
        message.setReceiver(identifiable2);
        message.setTimestamp(l);
        message.setPushContent(MessageParser.parsePushContent(multiCastAppSessionChatRequest.hasOsPushMsg() ? multiCastAppSessionChatRequest.getOsPushMsg() : null));
        message.setUuid(multiCastAppSessionChatRequest.getUuid());
        message.setState(new Archived());
        return message;
    }

    private static Message parseMessageModified(ByteString byteString, long l) {
        Im.ChatMessageModifiedRequest chatMessageModifiedRequest = (Im.ChatMessageModifiedRequest)((Im.ChatMessageModifiedRequest.Builder)Im.ChatMessageModifiedRequest.newBuilder().mergeFrom(byteString)).build();
        Content content = Content.makeContent(chatMessageModifiedRequest.getMsgType(), chatMessageModifiedRequest.getContent().toByteArray());
        if (content == null) {
            Log.e(TAG, Trace.once().method("parseMessageModified").msg("Unrecognized content").info("msgType", chatMessageModifiedRequest.getMsgType()).info("content", chatMessageModifiedRequest.getContent()));
            return null;
        }
        Message message = new Message();
        message.setContent(content);
        Identifiable identifiable = IdentifiableHelper.makeIdentifiable(chatMessageModifiedRequest.getFromIdType(), chatMessageModifiedRequest.getFromId());
        Identifiable identifiable2 = IdentifiableHelper.makeIdentifiable(chatMessageModifiedRequest.getToIdType(), chatMessageModifiedRequest.getToId());
        if (identifiable == null || identifiable2 == null) {
            Log.w(TAG, Trace.once().method("parseMessageModified").msg("Unrecognized sender/receiver").info("sender", chatMessageModifiedRequest.getFromIdType()).info("receiver", chatMessageModifiedRequest.getToIdType()));
        }
        message.setSender(identifiable);
        message.setReceiver(identifiable2);
        message.setPushContent(null);
        message.setUuid(chatMessageModifiedRequest.getUuid());
        message.setTimestamp(l);
        message.setState(new Archived());
        return message;
    }

    private static Message parseBatchP2PMessage(ByteString byteString, long l) {
        Chat.BatchP2PChatRequest batchP2PChatRequest = (Chat.BatchP2PChatRequest)((Chat.BatchP2PChatRequest.Builder)Chat.BatchP2PChatRequest.newBuilder().mergeFrom(byteString)).build();
        Content content = Content.makeContent(batchP2PChatRequest.getMsgType(), batchP2PChatRequest.getContent().toByteArray());
        if (content == null) {
            Log.e(TAG, Trace.once().method("parseBatchP2PMessage").msg("Unrecognized content").info("msgType", batchP2PChatRequest.getMsgType()).info("content", batchP2PChatRequest.getContent()));
            return null;
        }
        Message message = new Message();
        message.setContent(content);
        message.setSender(new User(batchP2PChatRequest.getFromUid()));
        message.setReceiver(HMR.getMe());
        message.setPushContent(MessageParser.parsePushContent(batchP2PChatRequest.getOsPushMsg()));
        message.setUuid(batchP2PChatRequest.getUuid());
        message.setTimestamp(l);
        message.setState(new Archived());
        return message;
    }

    private static Message parseMultiCastP2PMessage(ByteString byteString, long l) {
        Chat.MultiCastP2PChatRequest multiCastP2PChatRequest = (Chat.MultiCastP2PChatRequest)((Chat.MultiCastP2PChatRequest.Builder)Chat.MultiCastP2PChatRequest.newBuilder().mergeFrom(byteString)).build();
        Content content = Content.makeContent(multiCastP2PChatRequest.getMsgType(), multiCastP2PChatRequest.getContent().toByteArray());
        if (content == null) {
            Log.e(TAG, Trace.once().method("parseMultiCastP2PMessage").msg("Unrecognized content").info("msgType", multiCastP2PChatRequest.getMsgType()).info("content", multiCastP2PChatRequest.getContent()));
            return null;
        }
        Message message = new Message();
        message.setContent(content);
        message.setSender(new User(multiCastP2PChatRequest.getFromUid()));
        message.setReceiver(HMR.getMe());
        message.setPushContent(MessageParser.parsePushContent(multiCastP2PChatRequest.getOsPushMsg()));
        message.setUuid(multiCastP2PChatRequest.getUuid());
        message.setTimestamp(l);
        message.setState(new Archived());
        return message;
    }

    private static Message parseModifyAppSessionMessage(ByteString byteString, long l) {
        Chat.ModifyAppSessionChatRequest modifyAppSessionChatRequest = (Chat.ModifyAppSessionChatRequest)((Chat.ModifyAppSessionChatRequest.Builder)Chat.ModifyAppSessionChatRequest.newBuilder().mergeFrom(byteString)).build();
        Content content = Content.makeContent(modifyAppSessionChatRequest.getMsgType(), modifyAppSessionChatRequest.getContent().toByteArray());
        if (content == null) {
            Log.e(TAG, Trace.once().method("parseModifyAppSessionChat").msg("Unrecognized content").info("msgType", modifyAppSessionChatRequest.getMsgType()).info("content", modifyAppSessionChatRequest.getContent()));
            return null;
        }
        Message message = new Message();
        message.setContent(content);
        Identifiable identifiable = IdentifiableHelper.makeIdentifiable(modifyAppSessionChatRequest.getFromIdType(), modifyAppSessionChatRequest.getFromId());
        Identifiable identifiable2 = IdentifiableHelper.makeIdentifiable(modifyAppSessionChatRequest.getToIdType(), modifyAppSessionChatRequest.getToId());
        if (identifiable == null || identifiable2 == null) {
            Log.w(TAG, Trace.once().method("parseModifyAppSessionChat").msg("Unrecognized sender/receiver").info("sender", modifyAppSessionChatRequest.getFromIdType()).info("receiver", modifyAppSessionChatRequest.getToIdType()));
        }
        message.setSender(identifiable);
        message.setReceiver(identifiable2);
        message.setPushContent(null);
        message.setUuid(modifyAppSessionChatRequest.getUuid());
        message.setTimestamp(l);
        message.setState(new Archived());
        return null;
    }

    private static Message parseBatchAppSessionMessage(ByteString byteString, long l) {
        Chat.BatchAppSessionChatRequest batchAppSessionChatRequest = (Chat.BatchAppSessionChatRequest)((Chat.BatchAppSessionChatRequest.Builder)Chat.BatchAppSessionChatRequest.newBuilder().mergeFrom(byteString)).build();
        Content content = Content.makeContent(batchAppSessionChatRequest.getMsgType(), batchAppSessionChatRequest.getContent().toByteArray());
        if (content == null) {
            Log.e(TAG, Trace.once().method("parseBatchAppSessionMessage").msg("Unrecognized content").info("msgType", batchAppSessionChatRequest.getMsgType()).info("content", batchAppSessionChatRequest.getContent()));
            return null;
        }
        Message message = new Message();
        message.setContent(content);
        Identifiable identifiable = IdentifiableHelper.makeIdentifiable(batchAppSessionChatRequest.getFromIdType(), batchAppSessionChatRequest.getFromId());
        Identifiable identifiable2 = IdentifiableHelper.makeIdentifiable(batchAppSessionChatRequest.getToIdType(), batchAppSessionChatRequest.getToId());
        if (identifiable == null || identifiable2 == null) {
            Log.w(TAG, Trace.once().method("parseBatchAppSessionMessage").msg("Unrecognized sender/receiver").info("sender", batchAppSessionChatRequest.getFromIdType()).info("receiver", batchAppSessionChatRequest.getToIdType()));
        }
        message.setSender(identifiable);
        message.setReceiver(identifiable2);
        message.setPushContent(MessageParser.parsePushContent(batchAppSessionChatRequest.getOsPushMsg()));
        message.setUuid(batchAppSessionChatRequest.getUuid());
        message.setTimestamp(l);
        message.setState(new Archived());
        return message;
    }

    private static Message parseBroadCastAppSessionMessage(ByteString byteString, long l) {
        Chat.BroadCastAppSessionChatRequest broadCastAppSessionChatRequest = (Chat.BroadCastAppSessionChatRequest)((Chat.BroadCastAppSessionChatRequest.Builder)Chat.BroadCastAppSessionChatRequest.newBuilder().mergeFrom(byteString)).build();
        Content content = Content.makeContent(broadCastAppSessionChatRequest.getMsgType(), broadCastAppSessionChatRequest.getContent().toByteArray());
        if (content == null) {
            Log.e(TAG, Trace.once().method("parseBroadCastAppSessionMessage").msg("Unrecognized content").info("msgType", broadCastAppSessionChatRequest.getMsgType()).info("content", broadCastAppSessionChatRequest.getContent()));
            return null;
        }
        Message message = new Message();
        message.setContent(content);
        Identifiable identifiable = IdentifiableHelper.makeIdentifiable(broadCastAppSessionChatRequest.getFromIdType(), broadCastAppSessionChatRequest.getFromId());
        Log.i(TAG, Trace.once().method("parseBroadCastAppSessionMessage").msg("sender").info("sender type", broadCastAppSessionChatRequest.getFromIdType()).info("id", broadCastAppSessionChatRequest.getFromId()));
        Identifiable identifiable2 = IdentifiableHelper.makeIdentifiable(broadCastAppSessionChatRequest.getToIdType(), broadCastAppSessionChatRequest.getToId());
        Log.i(TAG, Trace.once().method("parseBroadCastAppSessionMessage").msg("receiver").info("receiver type", broadCastAppSessionChatRequest.getToIdType()).info("id", broadCastAppSessionChatRequest.getToId()));
        if (identifiable == null || identifiable2 == null) {
            Log.w(TAG, Trace.once().method("parseBroadCastAppSessionMessage").msg("Unrecognized sender/receiver").info("sender", broadCastAppSessionChatRequest.getFromIdType()).info("receiver", broadCastAppSessionChatRequest.getToIdType()));
        }
        message.setSender(identifiable);
        message.setReceiver(identifiable2);
        message.setPushContent(null);
        message.setUuid(broadCastAppSessionChatRequest.getUuid());
        message.setTimestamp(l);
        message.setState(new Archived());
        return message;
    }

    private static Message parseGroupNotification(ByteString byteString, long l) {
        Notify.GroupNotifyRequest groupNotifyRequest = (Notify.GroupNotifyRequest)((Notify.GroupNotifyRequest.Builder)Notify.GroupNotifyRequest.newBuilder().mergeFrom(byteString)).build();
        Message message = new Message();
        Notification notification = new Notification(groupNotifyRequest.getChatContent() == null ? null : groupNotifyRequest.getChatContent().toByteArray());
        message.setContent(notification);
        message.setSender(new User(groupNotifyRequest.getFromUid()));
        message.setReceiver(new Group(groupNotifyRequest.getGroupId()));
        message.setPushContent(null);
        message.setUuid(groupNotifyRequest.getUuid());
        message.setTimestamp(l);
        message.setState(new Archived());
        return message;
    }

    private static Message parseBatchNotification(ByteString byteString, long l) {
        Notify.BatchNotifyRequest batchNotifyRequest = (Notify.BatchNotifyRequest)((Notify.BatchNotifyRequest.Builder)Notify.BatchNotifyRequest.newBuilder().mergeFrom(byteString)).build();
        Message message = new Message();
        Notification notification = new Notification(batchNotifyRequest.getChatContent() == null ? null : batchNotifyRequest.getChatContent().toByteArray());
        message.setContent(notification);
        message.setSender(new User(batchNotifyRequest.getFromUid()));
        message.setReceiver(HMR.getMe());
        message.setPushContent(MessageParser.parsePushContent(batchNotifyRequest.hasOsPushMsg() ? batchNotifyRequest.getOsPushMsg() : null));
        message.setUuid(batchNotifyRequest.getUuid());
        message.setTimestamp(l);
        message.setState(new Archived());
        return message;
    }

    private static Message parseInsertChatHistory(ByteString byteString, long l) {
        Chat.InsertChatHistoryRequest insertChatHistoryRequest = (Chat.InsertChatHistoryRequest)((Chat.InsertChatHistoryRequest.Builder)Chat.InsertChatHistoryRequest.newBuilder().mergeFrom(byteString)).build();
        Content content = Content.makeContent(insertChatHistoryRequest.getMsgType(), insertChatHistoryRequest.getContent().toByteArray());
        if (content == null) {
            Log.e(TAG, Trace.once().method("parseInsertChatHistory").msg("Unrecognized content").info("msgType", insertChatHistoryRequest.getMsgType()).info("content", insertChatHistoryRequest.getContent()));
            return null;
        }
        Message message = new Message();
        message.setContent(content);
        Identifiable identifiable = IdentifiableHelper.makeIdentifiable(insertChatHistoryRequest.getFromIdType(), insertChatHistoryRequest.getFromId());
        Identifiable identifiable2 = IdentifiableHelper.makeIdentifiable(insertChatHistoryRequest.getToIdType(), insertChatHistoryRequest.getToId());
        if (identifiable == null || identifiable2 == null) {
            Log.w(TAG, Trace.once().method("parseInsertChatHistory").msg("Unrecognized sender/receiver").info("sender", insertChatHistoryRequest.getFromIdType()).info("receiver", insertChatHistoryRequest.getToIdType()));
        }
        message.setSender(identifiable);
        message.setReceiver(identifiable2);
        message.setPushContent(null);
        message.setUuid(insertChatHistoryRequest.getUuid());
        message.setTimestamp(l);
        message.setState(new Archived());
        return message;
    }

    private static PushContent parsePushContent(Im.OsPushMsg osPushMsg) {
        if (osPushMsg == null) {
            return null;
        }
        return new PushContent(osPushMsg.getTitle(), osPushMsg.getContent(), osPushMsg.getPayload().toByteArray(), osPushMsg.getIcon());
    }
}

