/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.blacklist;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.blacklist.RPCBlockUser;
import com.hummer.im._internals.blacklist.RPCGetBlackList;
import com.hummer.im._internals.blacklist.RPCUnblockUser;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.Source;
import com.hummer.im._internals.proto.BuddyOuterClass;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.OnSuccessArg;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im.service.BlacklistService;
import com.hummer.im.service.Channel;
import com.hummer.im.service.MQService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class BlacklistServiceImpl
implements ServiceProvider.Service,
BlacklistService,
MQService.MsgParser {
    private static final String TAG = "BlacklistService";
    private final Set<User> blockedUsers = new HashSet<User>();
    private final Set<BlacklistService.BlacklistListener> observers = new HashSet<BlacklistService.BlacklistListener>();

    @Override
    public Class[] staticDependencies() {
        return new Class[]{MQService.class};
    }

    @Override
    public Class[] inherentDynamicDependencies() {
        return new Class[]{Channel.class};
    }

    @Override
    public Class[] plantingDynamicDependencies() {
        return new Class[]{MQService.class};
    }

    @Override
    public void initService() {
        HMR.getService(MQService.class).registerMsgParser(this);
    }

    @Override
    public void openService(@NonNull RichCompletion richCompletion) {
        if (!HMR.getMe().isAnonymous()) {
            ServiceProvider.get(Channel.class).run(new RPCGetBlackList(new RichCompletionArg<List<User>>("BlacklistService::RPCGetBlackList").onSuccess(new OnSuccessArg<List<User>>(){

                @Override
                public void onSuccess(List<User> list) {
                    BlacklistServiceImpl.this.blockedUsers.addAll(list);
                    BlacklistServiceImpl.this.notifyBlacklistChanged();
                }
            })));
        }
        CompletionUtils.dispatchSuccess(richCompletion);
    }

    @Override
    public void closeService() {
        this.blockedUsers.clear();
    }

    @Override
    public void listBlacklist(HMR.CompletionArg<List<User>> completionArg) {
        RichCompletionArg<List<User>> richCompletionArg = new RichCompletionArg<List<User>>(completionArg, "BlacklistService::listBlacklist");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure(richCompletionArg, new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        CompletionUtils.dispatchSuccess(richCompletionArg, new ArrayList<User>(this.blockedUsers));
    }

    @Override
    public void isBlocked(@NonNull User user, HMR.CompletionArg<Boolean> completionArg) {
        RichCompletionArg<Boolean> richCompletionArg = new RichCompletionArg<Boolean>(completionArg, "BlacklistService::isBlocked");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure(richCompletionArg, new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        CompletionUtils.dispatchSuccess(richCompletionArg, this.blockedUsers.contains(user));
    }

    @Override
    public void block(final @NonNull User user, @NonNull HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "BlacklistService::block");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure(richCompletion, new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        ServiceProvider.get(Channel.class).run(new RPCBlockUser(user, richCompletion.beforeSuccess(new Runnable(){

            @Override
            public void run() {
                BlacklistServiceImpl.this.blockUser(user);
            }
        })));
    }

    @Override
    public void unblock(final @NonNull User user, @NonNull HMR.Completion completion) {
        RichCompletion richCompletion = new RichCompletion(completion, "BlacklistService::unblock");
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchFailure(richCompletion, new Error(1011, "User not login, or using anonymous mode"));
            return;
        }
        ServiceProvider.get(Channel.class).run(new RPCUnblockUser(user, richCompletion.beforeSuccess(new Runnable(){

            @Override
            public void run() {
                BlacklistServiceImpl.this.unblockUser(user);
            }
        })));
    }

    @Override
    public void addListener(final @NonNull BlacklistService.BlacklistListener blacklistListener) {
        HMRContext.work.async("BlacklistService::addListener", new Runnable(){

            @Override
            public void run() {
                BlacklistServiceImpl.this.observers.add(blacklistListener);
                Log.i(BlacklistServiceImpl.TAG, Trace.once().method("addListener").info("listener", blacklistListener.getClass().getSimpleName()).info("size", BlacklistServiceImpl.this.observers.size()));
                BlacklistServiceImpl.this.notifyBlacklistChanged();
            }
        });
    }

    @Override
    public void removeListener(final @NonNull BlacklistService.BlacklistListener blacklistListener) {
        HMRContext.work.async("BlacklistService::removeListener", new Runnable(){

            @Override
            public void run() {
                BlacklistServiceImpl.this.observers.remove(blacklistListener);
                Log.i(BlacklistServiceImpl.TAG, Trace.once().method("removeListener").info("listener", blacklistListener.getClass().getSimpleName()).info("size", BlacklistServiceImpl.this.observers.size()));
            }
        });
    }

    @Override
    public void parse(Im.Msg msg, Source source) {
        if (msg.getAction() == Im.Action.kNotifyBlacklistAddedRequest) {
            this.handleAddingMessage(msg);
        } else if (msg.getAction() == Im.Action.kNotifyBlacklistRemovedRequest) {
            this.handleRemovingMessage(msg);
        }
    }

    private void handleAddingMessage(Im.Msg msg) {
        BuddyOuterClass.NotifyBlacklistAddedRequest notifyBlacklistAddedRequest = (BuddyOuterClass.NotifyBlacklistAddedRequest)((BuddyOuterClass.NotifyBlacklistAddedRequest.Builder)BuddyOuterClass.NotifyBlacklistAddedRequest.newBuilder().mergeFrom(msg.getContent())).build();
        User user = new User(notifyBlacklistAddedRequest.getInitiateUid());
        User user2 = new User(notifyBlacklistAddedRequest.getAddedUid());
        if (Identifiable.equals(user, HMR.getMe())) {
            this.blockUser(user2);
        } else {
            this.notifyBlockedBy(user);
        }
    }

    private void handleRemovingMessage(Im.Msg msg) {
        BuddyOuterClass.NotifyBlacklistRemovedRequest notifyBlacklistRemovedRequest = (BuddyOuterClass.NotifyBlacklistRemovedRequest)((BuddyOuterClass.NotifyBlacklistRemovedRequest.Builder)BuddyOuterClass.NotifyBlacklistRemovedRequest.newBuilder().mergeFrom(msg.getContent())).build();
        User user = new User(notifyBlacklistRemovedRequest.getInitiateUid());
        User user2 = new User(notifyBlacklistRemovedRequest.getRemovedUid());
        if (Identifiable.equals(user, HMR.getMe())) {
            this.unblockUser(user2);
        } else {
            this.notifyUnblockedBy(user);
        }
    }

    private void notifyBlacklistChanged() {
        final ArrayList<User> arrayList = new ArrayList<User>(this.blockedUsers);
        DispatchQueue.main.async("BlacklistService::notifyBlacklistChanged", new Runnable(){

            @Override
            public void run() {
                for (BlacklistService.BlacklistListener blacklistListener : BlacklistServiceImpl.this.observers) {
                    blacklistListener.onUpdateBlacklist(arrayList);
                }
            }
        });
    }

    private void notifyBlockedBy(final User user) {
        DispatchQueue.main.async("BlacklistService::notifyBlockedBy", new Runnable(){

            @Override
            public void run() {
                for (BlacklistService.BlacklistListener blacklistListener : BlacklistServiceImpl.this.observers) {
                    blacklistListener.onBlockedByUser(user);
                }
            }
        });
    }

    private void notifyUnblockedBy(final User user) {
        DispatchQueue.main.async("BlacklistService::notifyUnblockedBy", new Runnable(){

            @Override
            public void run() {
                for (BlacklistService.BlacklistListener blacklistListener : BlacklistServiceImpl.this.observers) {
                    blacklistListener.onUnblockedByUser(user);
                }
            }
        });
    }

    private void blockUser(final User user) {
        if (!this.blockedUsers.add(user)) {
            return;
        }
        DispatchQueue.main.async("BlacklistService::blockUser", new Runnable(){

            @Override
            public void run() {
                for (BlacklistService.BlacklistListener blacklistListener : BlacklistServiceImpl.this.observers) {
                    blacklistListener.onBlockUser(user);
                }
            }
        });
        this.notifyBlacklistChanged();
    }

    private void unblockUser(final User user) {
        if (!this.blockedUsers.remove(user)) {
            return;
        }
        DispatchQueue.main.async("BlacklistService::unblockUser", new Runnable(){

            @Override
            public void run() {
                for (BlacklistService.BlacklistListener blacklistListener : BlacklistServiceImpl.this.observers) {
                    blacklistListener.onUnblockUser(user);
                }
            }
        });
        this.notifyBlacklistChanged();
    }
}

