/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import android.support.annotation.NonNull;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.PrefStorage;
import com.hummer.im._internals.blacklist.BlacklistServiceImpl;
import com.hummer.im._internals.channel.ChannelStateServiceImp;
import com.hummer.im._internals.chatsvc.ChatServiceImpl;
import com.hummer.im._internals.chatsvc.MessageParser;
import com.hummer.im._internals.chatsvc.RPCSendAppSessionMessage;
import com.hummer.im._internals.chatsvc.RPCSendMessage;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.MQServiceImpl;
import com.hummer.im._internals.mq.Source;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.roaming.RoamingServiceImpl;
import com.hummer.im._internals.services.upload.UploadServiceImp;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.AsciiTable;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im._internals.user.UserServiceImpl;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.PushContent;
import com.hummer.im.model.chat.contents.Audio;
import com.hummer.im.model.chat.contents.Image;
import com.hummer.im.model.chat.contents.Text;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.id.AppSession;
import com.hummer.im.model.id.Group;
import com.hummer.im.model.id.IDFactory;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im.service.BlacklistService;
import com.hummer.im.service.Channel;
import com.hummer.im.service.ChannelStateService;
import com.hummer.im.service.ChatService;
import com.hummer.im.service.MQService;
import com.hummer.im.service.RoamingService;
import com.hummer.im.service.UploadService;
import com.yy.yylogger.Logger;
import com.yy.yylogger.mode.Delegate;
import com.yy.yylogger.mode.IChannelMode;
import com.yy.yylogger.scope.IScope;
import com.yy.yylogger.scope.ScopeAll;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class SPCoreModuleLoader
implements ServiceProvider.ModuleLoader {
    @Override
    public void initModule() {
        SPCoreModuleLoader.showInitMessage();
    }

    @Override
    public Map<Class, ServiceProvider.Service> getServices() {
        return new HashMap<Class, ServiceProvider.Service>(){
            {
                this.put(BlacklistService.class, new BlacklistServiceImpl());
                this.put(PrefStorage.class, PrefStorage.storage());
                this.put(UserService.class, new UserServiceImpl());
                this.put(MQService.class, new MQServiceImpl());
                this.put(ChatService.class, new ChatServiceImpl());
                this.put(LoggerService.class, new LoggerService());
                this.put(UploadService.class, new UploadServiceImp());
                this.put(RoamingService.class, new RoamingServiceImpl());
                this.put(ChannelStateService.class, new ChannelStateServiceImp());
            }
        };
    }

    private static void showInitMessage() {
        AsciiTable.log(40, "Welcome to Hummer", new String[][]{{"version", HMR.getVersion()}, {"appId", String.valueOf(HMRContext.appId)}});
    }

    private static void registerChatContentCodecs() {
        Text.registerCodecs();
        Image.registerCodecs();
        Audio.registerCodecs();
    }

    private static void registerIdExtensions() {
        SPCoreModuleLoader.registerUserIdExtension();
    }

    private static void registerUserIdExtension() {
        IDFactory.registerExtension(new IDFactory.Extension(){

            @Override
            public Identifiable makeId(String string) {
                if (string.matches("^user_\\d+$")) {
                    return new User(Long.parseLong(string.substring(5)));
                }
                if (string.matches("^group_\\d+$")) {
                    return new Group(Long.parseLong(string.substring(6)));
                }
                if (string.contains("app_")) {
                    String[] stringArray = string.split("_");
                    if (stringArray.length < 2) {
                        Log.e("SPCoreModuleLoader", Trace.once().method("IDFactory.Extension").msg("AppSession").info("error", "[Format error]: format should be app/xxx"));
                        return null;
                    }
                    long l = Long.parseLong(stringArray[1]);
                    String string2 = stringArray[2];
                    return new AppSession(string2, l);
                }
                return null;
            }

            @Override
            public String makeString(Identifiable identifiable) {
                if (identifiable instanceof User) {
                    return String.format(Locale.US, "%s_%d", "user", identifiable.getId());
                }
                if (identifiable instanceof Group) {
                    return String.format(Locale.US, "%s_%d", "group", identifiable.getId());
                }
                if (identifiable instanceof AppSession) {
                    return String.format(Locale.US, "%s_%d_%s", "app", identifiable.getId(), ((AppSession)identifiable).getType());
                }
                return null;
            }
        });
    }

    private static void registerChatServiceExtensions() {
        ChatServiceImpl.registerSendingExtension(new ChatServiceImpl.SendingExtension(){

            @Override
            public Channel.RPC makeSendingRPC(Message message, RichCompletion richCompletion) {
                if (message.getSender() instanceof User && message.getReceiver() instanceof User) {
                    return new RPCSendMessage(message, richCompletion);
                }
                if (message.getReceiver() instanceof AppSession) {
                    return new RPCSendAppSessionMessage(message, richCompletion);
                }
                return null;
            }
        });
        ChatServiceImpl.registerParserExtension(new ChatServiceImpl.ParserExtension(){

            public String toString() {
                return "Core";
            }

            @Override
            public Message parseMessage(String string, String string2, byte[] byArray) {
                return null;
            }

            @Override
            public Message parseMessage(Im.Msg msg, Source source) {
                return MessageParser.parseContent(msg.getContent(), msg.getTimestamp(), msg.getAction());
            }

            private PushContent parsePushContent(Im.OsPushMsg osPushMsg) {
                if (osPushMsg == null) {
                    return null;
                }
                return new PushContent(osPushMsg.getTitle(), osPushMsg.getContent(), osPushMsg.getPayload().toByteArray(), osPushMsg.getIcon());
            }
        });
    }

    static class LoggerService
    implements ServiceProvider.Service {
        LoggerService() {
        }

        @Override
        public void initService() {
            SPCoreModuleLoader.registerChatContentCodecs();
            SPCoreModuleLoader.registerIdExtensions();
            SPCoreModuleLoader.registerChatServiceExtensions();
            MQService mQService = HMR.getService(MQService.class);
            mQService.addSource(new Source(new Source.Private(null, null, 300000L)));
            mQService.addSource(new Source(new Source.Shared(1L, null)));
        }

        @Override
        public Class[] staticDependencies() {
            return null;
        }

        @Override
        public Class[] inherentDynamicDependencies() {
            return new Class[]{Channel.class};
        }

        @Override
        public Class[] plantingDynamicDependencies() {
            return null;
        }

        @Override
        public void openService(@NonNull RichCompletion richCompletion) {
            Logger.enablePassiveReport((IChannelMode)new Delegate(), (long)HMR.getMe().getId(), (IScope)new ScopeAll(), (IChannelMode.LoginCallback)new IChannelMode.LoginCallback(){

                public void success(String string) {
                }

                public void failed(int n, int n2, String string) {
                }
            });
            CompletionUtils.dispatchSuccess(richCompletion);
        }

        @Override
        public void closeService() {
            Logger.disablePassiveReport((IChannelMode.LogoutCallback)new IChannelMode.LogoutCallback(){

                public void success(String string) {
                }

                public void failed(int n, int n2, String string) {
                }
            });
        }
    }
}

