/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.MessageLite;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.shared.HiidoReporter;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.service.Channel;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Locale;

public abstract class IMRPC<Request, RequestBuilder, Response>
implements Channel.RPC {
    private Trace.Flow flow = new Trace.Flow();
    private long startTs;
    private static final String FunctionNamePrefix = "cim.proto.ProxyService";

    public abstract void buildHummerRequest(@NonNull RequestBuilder var1);

    public String describeHummerRequest(Request Request) {
        return Request.toString();
    }

    public abstract void handleHummerSuccess(@NonNull Response var1);

    public abstract void handleHummerError(@Nullable Response var1, @NonNull Error var2);

    public abstract String getHummerFunction();

    public String describeHummerResponse(@NonNull Response Response) {
        return Response.toString();
    }

    @Override
    public String serviceName() {
        HMRContext.Region region = HMRContext.region;
        return String.format(Locale.US, "svc_%s_cim_%s_%s_proxy", region.area, region.type, region.name);
    }

    @Override
    public String getFunctionName() {
        return "cim.proto.ProxyService." + this.getHummerFunction();
    }

    @Override
    public String protoType() {
        return "yy-rp-pb";
    }

    public long getLogId() {
        return this.flow.logId;
    }

    @Override
    public byte[] getRequestBytes() {
        Method method;
        Method method2;
        Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Method method3 = clazz.getMethod("newBuilder", new Class[0]);
        Object object = method3.invoke(null, new Object[0]);
        if (object == null) {
            Log.e("IMRPC", Trace.once().method("getRequestBytes").info("RequestBuilder", null));
        }
        if ((method2 = object.getClass().getMethod("setLogId", Long.TYPE)) == null) {
            Log.e("IMRPC", Trace.once().method("getRequestBytes").info("Method setLogId", null));
        }
        method2.invoke(object, this.getLogId());
        Method method4 = object.getClass().getMethod("setAppId", Long.TYPE);
        if (method4 == null) {
            Log.e("IMRPC", Trace.once().method("getRequestBytes").info("Method setAppId", null));
        }
        method4.invoke(object, HMRContext.appId);
        try {
            method = object.getClass().getMethod("setSelfUid", Long.TYPE);
            method.invoke(object, HMR.getMe().getId());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        method = object.getClass().getMethod("build", new Class[0]);
        if (object == null) {
            Log.e("IMRPC", Trace.once().method("getRequestBytes").info("Methodbuilder", null));
        }
        this.buildHummerRequest(object);
        MessageLite messageLite = (MessageLite)method.invoke(object, new Object[0]);
        Log.i("IMRPC", this.flow.trace().method(this.getHummerFunction()).msg("-> {" + this.describeHummerRequest(messageLite)) + "}");
        this.startTs = System.currentTimeMillis();
        return messageLite.toByteArray();
    }

    @Override
    public void handleError(@NonNull Error error) {
        this.handleHummerError(null, error);
    }

    @Override
    public void handleResponse(@NonNull byte[] byArray) {
        Method method;
        Method method2;
        Object object;
        Method method3;
        Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[2];
        if (clazz == null) {
            Log.e("IMRPC", Trace.once().method("handleResponse").info("\u9519\u8bef\u7684HummerRPC\u7ee7\u627f\u5b9e\u73b0: ", null));
        }
        if ((method3 = clazz.getMethod("newBuilder", new Class[0])) == null) {
            Log.e("IMRPC", Trace.once().method("handleResponse").info("Method newBuilder: ", null));
        }
        if ((object = method3.invoke(null, new Object[0])) == null) {
            Log.e("IMRPC", Trace.once().method("handleResponse").info("Object builder: ", null));
        }
        if ((method2 = object.getClass().getMethod("mergeFrom", byte[].class)) == null) {
            Log.e("IMRPC", Trace.once().method("handleResponse").info("Method mergeFrom: ", null));
        }
        if ((method = object.getClass().getMethod("build", new Class[0])) == null) {
            Log.e("IMRPC", Trace.once().method("handleResponse").info("Method build: ", null));
        }
        method2.invoke(object, new Object[]{byArray});
        Object object2 = method.invoke(object, new Object[0]);
        Method method4 = object2.getClass().getMethod("getCode", new Class[0]);
        Method method5 = object2.getClass().getMethod("getMsg", new Class[0]);
        if (method4 == null) {
            Log.e("IMRPC", Trace.once().method("handleResponse").info("Method getCode: ", method4));
        }
        if (method5 == null) {
            Log.e("IMRPC", Trace.once().method("handleResponse").info("Method getMsg: ", method5));
        }
        Integer n = (Integer)method4.invoke(object2, new Object[0]);
        String string = (String)method5.invoke(object2, new Object[0]);
        long l = System.currentTimeMillis() - this.startTs;
        if (n == 0) {
            Log.i("IMRPC", this.flow.trace().method(this.getHummerFunction()).msg("<- Succeed {" + this.describeHummerResponse(object2)) + "}");
            this.handleHummerSuccess(object2);
        } else {
            l = 0L;
            Error error = new Error(n, string);
            Log.e("IMRPC", error, this.flow.trace().method(this.getHummerFunction()).msg("<- Failed {" + new StringChain().add("logId", this.getLogId()).add("response", this.describeHummerResponse(object2)).toString() + "}"));
            this.handleHummerError(object2, error);
        }
        HiidoReporter.reportReturnCodeTemporary(this.getHummerFunction(), l, n);
    }
}

