package com.hummer.im.service;

import android.support.annotation.NonNull;

import com.hummer.im._internals.services.upload.Uploader;

/**
 * 文件上传服务接口，所有Hummer的资源托管都会通过该接口来访问
 **/
public interface UploadService {

    /**
     注册上传器
     业务可以根据具体需要来自定义自己的上传器，如业务不希望上传到 Hummer 的阿里云服务

     @param uploader 业务自定义的上传器
     */
    void registerUploader(@NonNull Uploader uploader);

    /**
     上传服务模块的上传器
     */
    Uploader getUploader();

    /**
     上传文件的接口
     该模块会根据具体的信息来实现进度共享的功能

     @param filePath 需要上传文件的本地URL
     @param callback 上传回调对象
     */
    void uploadFile(@NonNull String filePath, @NonNull Uploader.UploadCallback<String> callback);

    /**
     取消上传的接口

     @param filePath 需要取消上传的本地URL
     */
    void cancelUploadFile(String filePath);
}
