package com.hummer.im.service;

import android.support.annotation.NonNull;

public interface ChannelStateService {

    /**
     用于标识长连接通道的状态

     - Unavailable:  初始化状态
     - Disconnected: 通道处于断开连接的状态
     - Connecting:   通道处于连接中的状态
     - Connected:    通道处于连接成功的状态
     */
    enum ChannelState {
        Unavailable,
        Disconnected,
        Connecting,
        Connected,
    }

    interface ChannelStateListener {
        /**
         当长连接状态变化时，会通过该通知进行回调

         @param fromState 旧的状态
         @param toState 新的状态
         */
        void onUpdateChannelState(ChannelState fromState, ChannelState toState);
    }

    /**
     * 获取Channel当前的连接状态
     */
    ChannelState getState();

    /**
     添加通道状态的监听器

     @param listener 需要添加的监听器
     */
    void addChannelStateListener(@NonNull ChannelStateListener listener);

    /**
     移除通道状态的监听器

     @param listener 需要移除的监听器
     */
    void removeChannelStateListener(@NonNull ChannelStateListener listener);
}
