package com.hummer.im.model.id;

import android.support.annotation.NonNull;

import java.util.ArrayList;
import java.util.List;

/**
 * 因为Identifiable到字符串的相互转换是非常高频的操作，因此这里定义一个工具类以提供可复用的实现
 * <p>
 * id的字符串常用于在数据持久化、Log输出等场景
 */
public class IDFactory {

    // Mark: 模块扩展支持

    public interface Extension {
        Identifiable makeId(String idString);
        String makeString(Identifiable id);
    }

    public static void registerExtension(@NonNull Extension extension) {
        extensions.add(extension);
    }

    public static Identifiable makeId(@NonNull String idString) {
        Identifiable id = null;

        for (Extension ext : extensions) {
            id = ext.makeId(idString);

            if (id != null) {
                break;
            }
        }

        return id;
    }

    public static String makeString(@NonNull Identifiable id) {
        String string = null;

        for (Extension ext : extensions) {
            string = ext.makeString(id);

            if (string != null) {
                break;
            }
        }

        return string;
    }

    static List<Extension> extensions = new ArrayList<>();
}
