package com.hummer.im.model.chat.store;

import com.hummer.im.model.chat.Message;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * 消息移除的条件描述
 */
@SuppressWarnings({"unused"})
public final class RemovingClauses {
    /**
     * 欲移除的消息列表
     */
    public List<Message> messages = new ArrayList<>();

    /**
     * 指定移除特定的消息
     * @param one 欲移除的消息对象
     */
    public RemovingClauses setOne(Message one) {
        messages = new ArrayList<>();
        messages.add(one);
        return this;
    }

    /**
     * 移除多个指定的消息
     *
     * @param some 欲移除的消息列表
     */
    public RemovingClauses setSome(Set<Message> some) {
        messages = new ArrayList<>(some);
        return this;
    }

    /**
     * 移除会话内所有的消息，即清空会话
     */
    public RemovingClauses setClearAll() {
        messages = null;
        return this;
    }

    @Override
    public String toString() {
        String string = "RemovingClauses{";

        if (messages == null) {
            string += "All";
        } else if (messages.size() == 1) {
            string += "One";
        } else {
            string += "Some";
        }

        return string;
    }
}
