package com.hummer.im.model.chat.states;

import com.hummer.im.Error;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.model.chat.Message;

public final class StateFactory {
    /**
     * 由于状态的序列化需求比较强烈，所以Hummer提供了它的序列化、反序列化方法
     * @param state 需要序列化为字符串的状态实例
     * @return 状态的字符串呈现
     */
    public static String makeString(Message.State state) {
        String st = null;
        if (state instanceof Init) {
            st = Init;
        } else if (state instanceof Preparing) {
            st = Preparing;
        } else if (state instanceof Delivering) {
            st = Delivering;
        } else if (state instanceof Archived) {
            st = Archived;
        } else if (state instanceof Failed) {
            Failed failed = (Failed) state;
            st = Failed + "_" + String.valueOf(failed.error.code) + "_" + String.valueOf(failed.error.desc);
        } else if (state instanceof Revoked) {
            st = Revoked;
        }

        if (st == null) {
            Log.e("MessageState", Trace.once().method("makeString")
                    .info("st", st));
        }

        return st;
    }

    /**
     * 由于状态的序列化需求比较强烈，所以Hummer提供了它的序列化、反序列化方法
     * @param string 通过makeString方法生成的状态字符串
     * @return 如果string参数可被解析为State实例，则返回对应的状态对象，否则返回null
     */
    public static Message.State makeState(String string) {
        Message.State state = null;
        String[] parts = string.split("_");

        String prefix = parts[0];
        switch (prefix) {
            case Init: {
                state = new Init();
                break;
            }
            case Preparing: {
                state = new Preparing();
                break;
            }
            case Delivering: {
                state = new Delivering();
                break;
            }
            case Archived: {
                state = new Archived();
                break;
            }
            case Failed: {
                Error error = new Error(Integer.parseInt(parts[1]), parts[2]);
                state = new Failed(error);
                break;
            }
            case Revoked: {
                state = new Revoked();
                break;
            }
            default:
                Log.e("MessageState", Trace.once().method("makeState")
                        .info("未支持的state类型:", prefix));
                break;
        }

        if (state == null) {
            Log.e("MessageState", Trace.once().method("makeState")
                    .info("BUGY! 未支持的state类型:", string));
        }

        return state;
    }

    private static final String Init       = "Init";
    private static final String Preparing  = "Preparing";
    private static final String Delivering = "Delivering";
    private static final String Archived   = "Archived";
    private static final String Failed     = "Failed";
    private static final String Revoked    = "Revoked";
}
