package com.hummer.im.model.chat.contents;

import com.hummer.im.model.chat.Content;

/**
 * Hummer内置的通知消息内容类型
 */
public final class Notification extends Content {

    /**
     * 构造一个通知消息
     * @param notification 消息的文本内容
     */
    public Notification(byte[] notification) {
        this.notification = notification;
    }

    /**
     * 获取消息的文本
     */
    public byte[] getNotification() {
        return notification;
    }

    @Override
    public String toString() {
        return "Notification{" + getNotification().toString() + "}";
    }

    private byte[] notification;
}
