package com.hummer.im.model.channel;

import java.util.Map;
import java.util.UUID;

public class CSMessage {
    private String type;
    private String uuid;
    private byte[] data;
    private long serverAcceptedTs;
    private Map<String, String> appExtras;

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setServerAcceptedTs(long serverAcceptedTs) {
        this.serverAcceptedTs = serverAcceptedTs;
    }

    public void setAppExtras(Map<String, String> appExtras) {
        this.appExtras = appExtras;
    }

    public String getType() {
        return type;
    }

    public String getUuid() {
        return uuid;
    }

    public byte[] getData() {
        return data;
    }

    public long getServerAcceptedTs() {
        return serverAcceptedTs;
    }

    public Map<String, String> getAppExtras() {
        return appExtras;
    }

    public CSMessage(final String type, final byte[] data) {
        this.type = type;
        this.data = data;
        setUuid(UUID.randomUUID().toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CSMessage)) {
            return false;
        }
        CSMessage that = (CSMessage) o;

        return (this.uuid != null) && (that.uuid != null) && uuid.equals(that.uuid);
    }

    @Override
    public int hashCode() {
        return uuid.hashCode();
    }

    @Override
    public String toString() {
        return "CSMessage{" +
                "uuid='" + uuid + '\'' +
                '}';
    }
}
