package com.hummer.im._internals.yyp.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class UnmarshalContainer {

    public static void unmarshalColUint64(Unpack up, Collection<Uint64> col) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); i++) {
            col.add(up.popUint64());
        }
    }

    public static void unmarshalMapStringString(Unpack up, Map<String, String> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); i++) {
            map.put(up.popString(), up.popString());
        }
    }

    public static void unmarshalMapStringListUint64(Unpack up,
                                                    HashMap<String, ArrayList<Uint64>> map) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); i++) {
            String key = up.popString();
            ArrayList<Uint64> innerList = new ArrayList<>();
            unmarshalColUint64(up, innerList);
            map.put(key, innerList);
        }
    }

    public static void unmarshalListString(Unpack up, List<String> list) {
        Uint32 size = up.popUint32();
        for (int i = 0; i < size.intValue(); i++) {
            list.add(up.popString());
        }
    }
}
