package com.hummer.im._internals.user;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.proto.User;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;

import java.util.Set;

public class RPCSetUserTags extends IMRPC<
        User.SetUserTagsRequest,
        User.SetUserTagsRequest.Builder,
        User.SetUserTagsResponse> {

    public static final String TAG = "RPCSetUserTags";

    RPCSetUserTags(@NonNull Set<String> tags, @Nullable RichCompletion completion) {
        this.tags       = tags;
        this.completion = completion;
    }

    @Override
    public String getHummerFunction() {
        return "SetUserTags";
    }

    @Override
    public void buildHummerRequest(@NonNull User.SetUserTagsRequest.Builder builder) {
        builder.addAllUserTags(tags);
    }

    @Override
    public String describeHummerRequest(User.SetUserTagsRequest req) {
        return "tags: " + tags.toString();
    }

    @Override
    public void handleHummerSuccess(@NonNull User.SetUserTagsResponse res) {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public String describeHummerResponse(@NonNull User.SetUserTagsResponse res) {
        return null;
    }

    @Override
    public void handleHummerError(@Nullable User.SetUserTagsResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    private final Set<String> tags;
    private final RichCompletion completion;
}
