package com.hummer.im._internals.shared.statis;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesCipher {

    private static final int BLOCK_SIZE = 16;
    private static final String AES_CBC_NOPADDING = "AES/CBC/NoPadding";
    private static final ThreadLocal<Cipher> Cipher_AES_CBC_NOPADDING = new ThreadLocal<Cipher>() {
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(AES_CBC_NOPADDING);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    private final byte[] mkey;

    public AesCipher(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null");
        }
        this.mkey = TextUtils.md5byte(key);
    }

    public String encryptTlogBytesBase64(byte[] data) throws Exception {
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] encryptData = this.encrypt(data);
        if (encryptData == null) {
            throw new Exception("EncryptData is null");
        }
        StringBuilder builder = new StringBuilder(data.length + encryptData.length * 2);
        builder.append(TextUtils.length2DecimalChar(data.length));
        builder.append(Base64Util.encode(encryptData));
        return builder.toString();
    }

    public byte[] encrypt(byte[] content) throws Exception {
        try {
            Cipher cipher = Cipher_AES_CBC_NOPADDING.get();
            SecretKeySpec keyspec = new SecretKeySpec(mkey, "AES");
            cipher.init(Cipher.ENCRYPT_MODE, keyspec, this.createIv());
            return cipher.doFinal(fillBlock(content));
        } catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private IvParameterSpec createIv() {
        byte[] ivb = new byte[this.mkey.length];
        System.arraycopy(mkey, 0, ivb, 0, this.mkey.length);
        return new IvParameterSpec(ivb);
    }

    private byte[] fillBlock(byte[] src) {
        int rest = src.length % BLOCK_SIZE;
        if (rest == 0) {
            return src;
        }
        int len = rest == 0 ? src.length : (src.length + BLOCK_SIZE - rest);
        byte[] r = new byte[len];
        System.arraycopy(src, 0, r, 0, src.length);
        return r;
    }

}