package com.hummer.im._internals.shared;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * <p> 任务运行耗时计算工具.
 * <p> 此类不会抛出异常, 运行状态不正确时, 会记录下来, 并在最后的toString()方法中打印出来.
 * <pre>{@code
 *     //使用方法:
 *     recorder.start("taskA"); //开始taskA任务的计时
 *     doTaskA();  //运行taskA任务
 *     recorder.stop("taskA"); //结束计时
 *     recorder.toString(); //查看结果.
 *     }
 * </pre>
 * <p>
 */
public class ETRecorder {

    /**
     * ETRecorder ID
     */
    private final String id;

    private static final long THRESHOLD = 365 * 24 * 60 * 60 * 1000L;

    private long initialMillis;

    private final Map<String, Pair> runnableMap = Collections.synchronizedMap(new LinkedHashMap<String, Pair>());

    private final List<String> exceptionList = Collections.synchronizedList(new ArrayList<String>()); //error info

    /**
     * 创建一个Recorder, 并且开始计时.
     *
     * @param id id
     */
    public ETRecorder(String id) {
        this.id = id;
        initialMillis = System.currentTimeMillis();
    }

    public String getId() {
        return this.id;
    }

    /**
     * 开始计时名为taskName的任务. 如果taskName的任务之前已经开始, 以首次开始计时为准.
     *
     * @param taskName 任务名
     * @see #stop(String taskName)
     */
    public void start(String taskName) {

    }

    /**
     * 停止名为taskName的任务的计时,如果此任务从来没有开始过, 则什么都不做.
     *
     * @param taskName 任务名
     * @see #start(String taskName)
     */
    public void stop(String taskName) {

    }

    private void checkAndReportElapsed(long elapse, String taskName) {

    }

    private void checkTaskList() {

    }

    // sdk内部时间脉冲，60 * 1000触发一次，检查task是否超时
    public void onTimerPulse() {

    }

    private static class Pair {
        long first; // 任务未完成时保存任务的开始时间 或者 任务完成时保存任务的执行时间
        long second; //任务执行完成时recorder当前已经走过的时间

        Pair(long first, long second) {
            this.first = first;
            this.second = second;
        }
    }
}