package com.hummer.im._internals.services.upload.YYaliOSS;

import com.alibaba.sdk.android.oss.common.auth.OSSFederationCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationToken;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.hummer.im.service.Channel;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im._internals.log.Log;


public final class OSSCredentialProviderImpl extends OSSFederationCredentialProvider {

    OSSCredentialProviderImpl(String uploadRegion) {
        mUploadRegion = uploadRegion;
    }

    //生成token，token的有效期为几分钟
    //有可能当上传的时候恰好token过期，这时候会上传失败
    //上传失败aliOSS的SDK会回调retry接口，我们需要在retry接口里把retry设为true来重新生成新的token
    void setRetrying(boolean isRetrying) {
        mIsRetrying = isRetrying;
    }

    @Override
    public synchronized OSSFederationToken getFederationToken() {
        // Checks if the STS token is expired.
        // To avoid returning staled data, here we pre-fetch the token 5 minutes a head of the real expiration.
        // The minimal expiration time is 15 minutes
        if (mCachedToken == null || mIsRetrying
                || DateUtil.getFixedSkewedTimeMillis() / 1000 > mCachedToken.getExpiration() - 10 * 60) {

            if (mCachedToken != null) {
                Log.w("getFederationToken", "token expired! current time: " +
                        DateUtil.getFixedSkewedTimeMillis() / 1000 +
                        " token expired: " + mCachedToken.getExpiration());
            }

            mCachedToken = getOssToken();
        }
        return mCachedToken;
    }

    private OSSFederationToken getOssToken() {
        GetOSSTokenMessage ossTokenMessage = new GetOSSTokenMessage(mUploadRegion);
        ServiceProvider.get(Channel.class).run(ossTokenMessage);
        ossTokenMessage.waitUntilFinish();
        return ossTokenMessage.getCachedToken();
    }

    private String mUploadRegion;
    private boolean mIsRetrying = false;
    private OSSFederationToken mCachedToken;
}

