package com.hummer.im._internals.services.upload.YYaliOSS;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.alibaba.sdk.android.oss.common.auth.OSSFederationToken;
import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im._internals.log.Log;

import java.util.concurrent.CountDownLatch;


public final class GetOSSTokenMessage extends IMRPC<
        GetOssTokenRequest,
        GetOssTokenRequest.Builder,
        GetOssTokenResponse> {

    GetOSSTokenMessage(String region) {
        this.latch  = new CountDownLatch(1);
        this.region = region;
    }

    @Override
    public String getHummerFunction() {
        return "GetOssToken";
    }

    @Override
    public void buildHummerRequest(@NonNull GetOssTokenRequest.Builder builder) {
        builder.setBucketPrefix("cim-" + region);
    }

    @Override
    public String describeHummerRequest(GetOssTokenRequest req) {
        return "region: " + region;
    }

    @Override
    public void handleHummerSuccess(@NonNull GetOssTokenResponse res) {
        token = new OSSFederationToken(res.getAk(), res.getSk(), res.getToken(), res.getExpiration());
        latch.countDown();
    }

    @Override
    public void handleHummerError(@Nullable GetOssTokenResponse res, @NonNull Error error) {
        latch.countDown();
    }

    @Override
    public String describeHummerResponse(@NonNull GetOssTokenResponse res) {
        return new StringChain().acceptNullElements()
                .add("ak",         res.getAk())
                .add("sk",         res.getSk())
                .add("token",      res.getToken())
                .add("expiration", res.getExpiration())
                .toString();
    }

    OSSFederationToken getCachedToken() {
        return token;
    }

    void waitUntilFinish() {
        //同步等待
        try {
            latch.await();
        } catch (InterruptedException e) {
            Log.e("GetOSSTokenMessage", "send getOssTokenRequest latch await excepted,exceptionDesc:" + e.getMessage());
        }
    }

    // SDK发送消息给CIM获取token是通过异步发送的，
    // 当aliOss的SDK获取token的时候要求是同步。
    // 需要mlatch把这个异步变成同步
    private final CountDownLatch latch;
    private final String         region;

    private OSSFederationToken token = null;

}
