package com.hummer.im._internals.services.upload;

import android.support.annotation.NonNull;

import com.hummer.im.Error;

public interface Uploader {
    /**
     * 开始上传指定本地路径的文件
     *
     * @param filePath 需要上传的文件名字
     * @param callback 上传回调对象
     * */
    void uploadFile(@NonNull String filePath, @NonNull UploadCallback<String> callback);

    void cancelUploadFile(@NonNull String filePath);

    String acquireThumbImageUrl(String originImageUrl, int width, int height);

    /**
     * 上传状态的变更回调，包括上传中的进度通知，上传成功，上传失败
     */
    interface UploadCallback<T> {
        /**
         * 上传进度回调
         *
         * @param value 上传进度值
         */
        void onProgress(float value);

        /**
         * 上传成功的回调
         *
         * @param url 存放文件的目的url
         */
        void onSuccess(T url);

        /**
         * 上传失败的回调
         *
         * @param err 描述失败原因的错误对象
         */
        void onFailure(Error err);
    }
}
