package com.hummer.im._internals.roaming;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.chatsvc.IdentifiableHelper;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.History;
import com.hummer.im._internals.proto.Im;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.store.FetchingClauses;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.id.Identifiable;

import java.util.ArrayList;
import java.util.List;

public class RPCFetchRemoteMessage extends IMRPC<History.ReverseListChatHistoryRequest,
        History.ReverseListChatHistoryRequest.Builder, History.ReverseListChatHistoryResponse> {

    private static final String TAG = "RPCFetchRemoteMessage";

    RPCFetchRemoteMessage(@NonNull Identifiable target,
                          @NonNull FetchingClauses clauses,
                          RichCompletionArg<History.ReverseListChatHistoryResponse> completion) {
        this.target = target;
        this.clauses = clauses;
        this.completion = completion;
    }

    @Override
    public void buildHummerRequest(@NonNull History.ReverseListChatHistoryRequest.Builder builder) {

         List<Im.ID> imIds = new ArrayList<>();
         if (clauses.getSenders() != null && clauses.getSenders().size() > 0) {
             for (Identifiable identifiable : clauses.getSenders()) {
                 imIds.add(Im.ID.newBuilder()
                         .setId(identifiable.getId())
                         .setIdType(IdentifiableHelper.makeStringFrom(identifiable))
                         .build());
             }
         }

        List<Integer> msgTypes = new ArrayList<>();
        if (clauses.getMessageTypes() != null && clauses.getMessageTypes().size() > 0) {
            for (Class<Content> clazz : clauses.getMessageTypes()) {
                try {
                    msgTypes.add(Content.getDataType(clazz.newInstance()));
                } catch (InstantiationException e) {
                    Log.e(TAG, Trace.once().method("buildHummerRequest")
                            .info("msg", "InstantiationException")
                            .info("exception", e));
                } catch (IllegalAccessException e) {
                    Log.e(TAG, Trace.once().method("buildHummerRequest")
                            .info("msg", "IllegalAccessException")
                            .info("exception", e));
                }
            }
        }

        builder.setBeginTimestamp(clauses.getBeforeTimestamp())
                .setLimit(clauses.getLimit())
                .setToIdType(IdentifiableHelper.makeStringFrom(target))
                .setToId(target.getId())
                .addAllFromIds(imIds)
                .addAllMsgTypes(msgTypes)
                .build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull History.ReverseListChatHistoryResponse res) {
        CompletionUtils.dispatchSuccess(completion, res);
    }

    @Override
    public void handleHummerError(@Nullable History.ReverseListChatHistoryResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull History.ReverseListChatHistoryResponse res) {
        return "has_more:" + res.getHasMore() +
                ", log_id:" + res.getLogId() +
                ", msg:" + res.getMsg() +
                ", msgs.size:" + res.getMsgsList().size();
    }

    @Override
    public String getHummerFunction() {
        return "ReverseListChatHistory";
    }

    private final Identifiable target;
    private final FetchingClauses clauses;
    private final RichCompletionArg<History.ReverseListChatHistoryResponse> completion;
}
