package com.hummer.im._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.User;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.CompletionUtils;

public class RPCReportPrivateSeqId extends IMRPC<User.SetMaxAcquiredSeqIDRequest,
        User.SetMaxAcquiredSeqIDRequest.Builder, User.SetMaxAcquiredSeqIDResponse> {

    public static final String TAG = "RPCReportPrivateSeqId";
    private final Trace.Flow flow = new Trace.Flow();
    private final long seqId;
    private final String topic;
    private final RichCompletion completion;

    public RPCReportPrivateSeqId(String topic, long seqId, RichCompletion completion) {
        this.topic = topic;
        this.seqId = seqId;
        this.completion = completion;
    }

    @Override
    public long getLogId() {
        return flow.logId;
    }

    @Override
    public String getHummerFunction() {
        return "SetMaxAcquiredSeqID";
    }

    @Override
    public void buildHummerRequest(@NonNull User.SetMaxAcquiredSeqIDRequest.Builder builder) throws Throwable {
        builder.setSeqId(seqId)
                .setTopic(topic == null ? "" : topic)
                .build().toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull User.SetMaxAcquiredSeqIDResponse res) throws Throwable {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleHummerError(@Nullable User.SetMaxAcquiredSeqIDResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull User.SetMaxAcquiredSeqIDResponse res) {
        return new StringChain().acceptNullElements()
                .add("code", res.getCode())
                .add("desc", res.getMsg())
                .toString();
    }
}

