package com.hummer.im._internals.log;

import com.yy.yylogger.Logger;

import static android.util.Log.DEBUG;
import static android.util.Log.ERROR;
import static android.util.Log.INFO;
import static android.util.Log.WARN;

public class HummerLogger implements Log.Logger {
    private final String module;

    public HummerLogger(String module) {
        this.module = module;
        Logger.createModule(module, true);
    }

    @Override
    public void log(int lv, String msg) {
        switch (lv) {
            case DEBUG:
                Logger.d(module, msg);
                break;
            case INFO:
                Logger.i(module, msg);
                break;
            case WARN:
                Logger.w(module, msg);
                break;
            case ERROR:
                Logger.e(module, msg);
                break;
            default:
                break;
        }
    }
}
