package com.hummer.im._internals.chatsvc;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.model.id.AppSession;
import com.hummer.im.model.id.Group;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;

public class IdentifiableHelper {

    static Identifiable makeIdentifiable(String idString, long id) {
        if (idString == null) {
            // 防止服务器更改协议，传入null字符串
            return null;
        }

        String[] parts = idString.split("/");
        if (parts.length <= 0) {
            return null;
        }

        final String type = parts[0].toLowerCase();
        final String subtype = parts.length >= 2 ? parts[1] : null;
        switch (type) {
            case "user":
                return new User(id);
            case "group":
                return new Group(id);
            case "app":
                if (subtype == null) {
                    Log.e("IdentifiableHelper", Trace.once().method("makeIdentifiable").msg("AppSession")
                            .info("error", "[Format error]: format should be app/xxx"));
                    return null;
                } else {
                    return new AppSession(subtype, id);
                }
            default:
                return null;
        }
    }

    public static String makeStringFrom(Identifiable target) {
        if (target instanceof User) {
            return "user";
        } else if (target instanceof Group) {
            return "group";
        } else if (target instanceof AppSession) {
            return "app/" + ((AppSession) target).getType();
        }
        return null;
    }
}
