package com.hummer.im._internals.blacklist;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.proto.BuddyOuterClass;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.User;
import com.hummer.im.model.completion.CompletionUtils;

import java.util.ArrayList;
import java.util.List;

public class RPCGetBlackList extends IMRPC<
        BuddyOuterClass.GetBlacklistRequest,
        BuddyOuterClass.GetBlacklistRequest.Builder,
        BuddyOuterClass.GetBlacklistResponse
        > {

    RPCGetBlackList(RichCompletionArg<List<User>> completion) {
        this.completion = completion;
    }

    @Override
    public String getHummerFunction() {
        return "GetBlacklist";
    }

    @Override
    public void buildHummerRequest(@NonNull BuddyOuterClass.GetBlacklistRequest.Builder builder) {
        // Nothing
    }

    @Override
    public String describeHummerRequest(BuddyOuterClass.GetBlacklistRequest req) {
        return null;
    }

    @Override
    public void handleHummerSuccess(@NonNull BuddyOuterClass.GetBlacklistResponse res) {
        ArrayList<User> users = new ArrayList<>();
        for (long id : res.getUidsList()) {
            users.add(new User(id));
        }

        CompletionUtils.dispatchSuccess(completion, users);
    }

    @Override
    public void handleHummerError(@Nullable BuddyOuterClass.GetBlacklistResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull BuddyOuterClass.GetBlacklistResponse res) {
        return null;
    }

    private final RichCompletionArg<List<User>> completion;
}


