package com.hummer.im._internals.blacklist;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.proto.BuddyOuterClass;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.id.User;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.completion.CompletionUtils;


public final class RPCBlockUser extends IMRPC<
        BuddyOuterClass.AddBlacklistRequest,
        BuddyOuterClass.AddBlacklistRequest.Builder,
        BuddyOuterClass.AddBlacklistResponse
        > {

    RPCBlockUser(@NonNull User user, RichCompletion completion) {
        this.user       = user;
        this.completion = completion;
    }

    @Override
    public String getHummerFunction() {
        return "AddBlacklist";
    }

    @Override
    public void buildHummerRequest(@NonNull BuddyOuterClass.AddBlacklistRequest.Builder builder) {
        builder.setUid(user.getId());
    }

    @Override
    public String describeHummerRequest(BuddyOuterClass.AddBlacklistRequest req) {
        return new StringChain().acceptNullElements().add("user", user).toString();
    }

    @Override
    public void handleHummerSuccess(@NonNull BuddyOuterClass.AddBlacklistResponse res) {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleHummerError(@Nullable BuddyOuterClass.AddBlacklistResponse res, @NonNull Error error) {
        CompletionUtils.dispatchFailure(completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull BuddyOuterClass.AddBlacklistResponse res) {
        return null;
    }

    private final User       user;
    private final RichCompletion completion;
}