package com.hummer.im._internals;

import android.content.Context;
import android.support.annotation.NonNull;

import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.ETRecorder;

import java.lang.ref.WeakReference;
import java.util.Locale;

public final class HMRContext {
    public static final DispatchQueue work = new DispatchQueue(new DispatchQueue.WorkerHandler("hmr_core"));
    public static final ETRecorder recorder  = new ETRecorder(Integer.toString(android.os.Process.myPid()));
    public static WeakReference<Context> appContext;
    public static Long   appId;
    public static Region region;
    public static String chatRoomRegion;

    /**
     * 获取Hummer初始化时传入的AppContext实例，该
     *
     * @return 如果Hummer已经正确初始化，则会返回
     */
    public static Context getAppContext() {
        return appContext.get();
    }

    /**
     * 获取Hummer 所使用的appId值，该值是在init调用时传入的
     *
     * @return 如果已经正确初始化，则返回业务在Hummer初始化时提供的appId，否则返回null
     */
    public static Long getAppId() {
        return appId;
    }

    /**
     * Hummer运行所需的环境参数，其中的type, name, region等字段取值，通常是在业务登录完成后，由业务服务器返回给
     * 业务客户端的。客户端应该将这些值透传给Hummer SDK。
     */
    public static final class Region {
        /**
         * 服务区域
         */
        public final String area;

        /**
         * 服务类型
         */
        public final String type;

        /**
         * 服务名称
         */
        public final String name;

        /**
         * 构造Hummer启用用户上下文时所需的环境配置参数
         */
        Region(String area, String type, String name) {
            this.type = type;
            this.name = name;
            this.area = area;
        }

        @Override
        public String toString() {
            return String.format(Locale.US, "%s/%s/%s", area, type, name);
        }

        public static Region make(@NonNull String components) {
            String[] parts  = components.split("/");
            String[] values = { "china", "public", "shared" };

            for (int i = 0; i < 3; ++i) {
                if (parts.length > i && !parts[i].isEmpty()) {
                    values[i] = parts[i];
                }
            }

            return new Region(values[0], values[1], values[2]);
        }
    }
}
