/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.completion;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccess;
import java.util.LinkedList;
import java.util.List;

public final class RichCompletion {
    private static final String TAG = "RichCompletion";
    private static final String DesPrefix = "RichCompletion::";
    private final DispatchQueue dispatchQueue;
    private List<Runnable> preSuccess = new LinkedList<Runnable>();
    private OnSuccess successHandler;
    private List<Runnable> postSuccess = new LinkedList<Runnable>();
    private List<Runnable> preFailure = new LinkedList<Runnable>();
    private OnFailure failureHandler;
    private List<Runnable> postFailure = new LinkedList<Runnable>();
    private RichCompletion decorated;
    private String description;

    public RichCompletion(@NonNull String string) {
        Looper looper = Looper.myLooper();
        if (looper == Looper.getMainLooper()) {
            this.dispatchQueue = new DispatchQueue(new DispatchQueue.LooperHandlerProvider(Looper.getMainLooper()));
            Log.i(TAG, Trace.once().method("CompletionInit").info("main dispatchQueue", this.dispatchQueue));
        } else if (looper == HMRContext.work.getHandler().getLooper()) {
            this.dispatchQueue = HMRContext.work;
            Log.i(TAG, Trace.once().method("CompletionInit").info("work dispatchQueue", this.dispatchQueue));
        } else {
            this.dispatchQueue = DispatchQueue.direct;
            Log.i(TAG, Trace.once().method("CompletionInit").info("internal dispatchQueue", this.dispatchQueue));
        }
        this.description = DesPrefix + string;
        HMRContext.recorder.start("[async]" + this.description);
    }

    public RichCompletion(final HMR.Completion completion, @NonNull String string) {
        this(string);
        if (completion == null) {
            HMRContext.recorder.stop("[async]" + this.description);
        }
        this.onSuccess(new OnSuccess(){

            @Override
            public void onSuccess() {
                if (completion != null) {
                    completion.onSuccess();
                }
            }
        }).onFailure(new OnFailure(){

            @Override
            public void onFailure(Error error) {
                if (completion != null) {
                    completion.onFailed(error);
                }
            }
        });
    }

    public RichCompletion(@NonNull Handler handler, @NonNull String string) {
        this.dispatchQueue = new DispatchQueue(new DispatchQueue.LooperHandlerProvider(handler.getLooper()));
        this.description = DesPrefix + string;
        HMRContext.recorder.start("[async]" + this.description);
        Log.i(TAG, Trace.once().method("CompletionInit").info("custom dispatchQueue with handler", this.dispatchQueue));
    }

    public RichCompletion decorate(@Nullable RichCompletion richCompletion) {
        if (this.decorated == null) {
            Log.e(TAG, Trace.once().method("decorate").info("\u53ea\u5141\u8bb8\u5bf9Completion\u8fdb\u884c\u4e00\u6b21\u88c5\u9970", this.decorated));
            return this;
        }
        this.decorated = richCompletion;
        return this;
    }

    public RichCompletion beforeSuccess(@NonNull Runnable runnable) {
        this.preSuccess.add(runnable);
        return this;
    }

    public RichCompletion onSuccess(@NonNull OnSuccess onSuccess) {
        this.successHandler = onSuccess;
        return this;
    }

    public RichCompletion afterSuccess(@NonNull Runnable runnable) {
        this.postSuccess.add(0, runnable);
        return this;
    }

    public RichCompletion beforeFailure(@NonNull Runnable runnable) {
        this.preFailure.add(runnable);
        return this;
    }

    public RichCompletion onFailure(@NonNull OnFailure onFailure) {
        this.failureHandler = onFailure;
        return this;
    }

    public RichCompletion afterFailure(@NonNull Runnable runnable) {
        this.postFailure.add(0, runnable);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    void dispatchSuccess() {
        Log.i(TAG, Trace.once().method("dispatchSuccess").info("dispatchQueue", this.dispatchQueue));
        this.dispatchQueue.async(this.description, new Runnable(){

            @Override
            public void run() {
                RichCompletion.dispatchActions(RichCompletion.this.preSuccess);
                if (RichCompletion.this.successHandler != null) {
                    Log.i(RichCompletion.TAG, Trace.once().method("dispatchSuccess").msg("dispatchSuccess"));
                    RichCompletion.this.successHandler.onSuccess();
                } else {
                    Log.i(RichCompletion.TAG, Trace.once().method("dispatchSuccess").msg("dispatchSuccess, successHandler == null"));
                }
                CompletionUtils.dispatchSuccess(RichCompletion.this.decorated);
                RichCompletion.dispatchActions(RichCompletion.this.postSuccess);
            }
        });
    }

    void dispatchFailure(final @NonNull Error error) {
        Log.i(TAG, Trace.once().method("dispatchFailure").info("dispatchQueue", this.dispatchQueue));
        this.dispatchQueue.async(this.description, new Runnable(){

            @Override
            public void run() {
                RichCompletion.dispatchActions(RichCompletion.this.preFailure);
                if (RichCompletion.this.failureHandler != null) {
                    Log.i(RichCompletion.TAG, Trace.once().method("dispatchFailure").msg("dispatchFailure"));
                    RichCompletion.this.failureHandler.onFailure(error);
                } else {
                    Log.i(RichCompletion.TAG, Trace.once().method("dispatchFailure").msg("dispatchFailure, failureHandler == null"));
                }
                CompletionUtils.dispatchFailure(RichCompletion.this.decorated, error);
                RichCompletion.dispatchActions(RichCompletion.this.postFailure);
            }
        });
    }

    private static void dispatchActions(@NonNull List<Runnable> list) {
        for (Runnable runnable : list) {
            runnable.run();
        }
    }
}

