/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat.states;

import com.hummer.im.Error;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.states.Archived;
import com.hummer.im.model.chat.states.Delivering;
import com.hummer.im.model.chat.states.Failed;
import com.hummer.im.model.chat.states.Init;
import com.hummer.im.model.chat.states.Preparing;
import com.hummer.im.model.chat.states.Revoked;

public final class StateFactory {
    private static final String Init = "Init";
    private static final String Preparing = "Preparing";
    private static final String Delivering = "Delivering";
    private static final String Archived = "Archived";
    private static final String Failed = "Failed";
    private static final String Revoked = "Revoked";

    public static String makeString(Message.State state) {
        String string = null;
        if (state instanceof Init) {
            string = Init;
        } else if (state instanceof Preparing) {
            string = Preparing;
        } else if (state instanceof Delivering) {
            string = Delivering;
        } else if (state instanceof Archived) {
            string = Archived;
        } else if (state instanceof Failed) {
            Failed failed = (Failed)state;
            string = "Failed_" + String.valueOf(failed.error.code) + "_" + String.valueOf(failed.error.desc);
        } else if (state instanceof Revoked) {
            string = Revoked;
        }
        if (string == null) {
            Log.e("MessageState", Trace.once().method("makeString").info("st", string));
        }
        return string;
    }

    public static Message.State makeState(String string) {
        String string2;
        Message.State state = null;
        String[] stringArray = string.split("_");
        switch (string2 = stringArray[0]) {
            case "Init": {
                state = new Init();
                break;
            }
            case "Preparing": {
                state = new Preparing();
                break;
            }
            case "Delivering": {
                state = new Delivering();
                break;
            }
            case "Archived": {
                state = new Archived();
                break;
            }
            case "Failed": {
                Error error = new Error(Integer.parseInt(stringArray[1]), stringArray[2]);
                state = new Failed(error);
                break;
            }
            case "Revoked": {
                state = new Revoked();
                break;
            }
            default: {
                Log.e("MessageState", Trace.once().method("makeState").info("\u672a\u652f\u6301\u7684state\u7c7b\u578b:", string2));
            }
        }
        if (state == null) {
            Log.e("MessageState", Trace.once().method("makeState").info("BUGY! \u672a\u652f\u6301\u7684state\u7c7b\u578b:", string));
        }
        return state;
    }
}

