/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.user;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.proto.User;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import java.util.Set;

public class RPCSetUserTags
extends IMRPC<User.SetUserTagsRequest, User.SetUserTagsRequest.Builder, User.SetUserTagsResponse> {
    public static final String TAG = "RPCSetUserTags";
    private final Set<String> tags;
    private final RichCompletion completion;

    RPCSetUserTags(@NonNull Set<String> set, @Nullable RichCompletion richCompletion) {
        this.tags = set;
        this.completion = richCompletion;
    }

    @Override
    public String getHummerFunction() {
        return "SetUserTags";
    }

    @Override
    public void buildHummerRequest(@NonNull User.SetUserTagsRequest.Builder builder) {
        builder.addAllUserTags(this.tags);
    }

    @Override
    public String describeHummerRequest(User.SetUserTagsRequest setUserTagsRequest) {
        return "tags: " + this.tags.toString();
    }

    @Override
    public void handleHummerSuccess(@NonNull User.SetUserTagsResponse setUserTagsResponse) {
        CompletionUtils.dispatchSuccess(this.completion);
    }

    @Override
    public String describeHummerResponse(@NonNull User.SetUserTagsResponse setUserTagsResponse) {
        return null;
    }

    @Override
    public void handleHummerError(@Nullable User.SetUserTagsResponse setUserTagsResponse, @NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, error);
    }
}

