/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared.statis;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class TextUtils {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final ThreadLocal<MessageDigest> MD5_DIGEST = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
        }
    };

    public static String bytes2hex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            cArray[n++] = hexDigits[by >>> 4 & 0xF];
            cArray[n++] = hexDigits[by & 0xF];
        }
        return new String(cArray);
    }

    public static String length2DecimalChar(int n) {
        String string = TextUtils.format8length(n);
        return string;
    }

    private static String format8length(int n) {
        StringBuffer stringBuffer = new StringBuffer(8);
        int n2 = 8 - (n + "").length();
        while (n2-- > 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public static byte[] md5byte(byte[] byArray) {
        MessageDigest messageDigest = MD5_DIGEST.get();
        messageDigest.reset();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        return byArray2;
    }

    public static boolean isBlank(CharSequence charSequence) {
        int n;
        if (charSequence == null || (n = charSequence.length()) == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence charSequence) {
        return !TextUtils.isBlank(charSequence);
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return !TextUtils.isEmpty(charSequence);
    }
}

