/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared.statis;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.shared.HiidoReporter;
import com.hummer.im._internals.shared.statis.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class StatisContent {
    public static final String ACT = "act";
    public static final String TIME = "time";
    public static final String APPKEY = "appkey";
    public static final String KEY = "key";
    protected static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            boolean bl = StatisContent.ACT.equals(string);
            boolean bl2 = StatisContent.ACT.equals(string2);
            if (!bl && !bl2) {
                return string.compareTo(string2);
            }
            if (!bl && bl2) {
                return 1;
            }
            if (bl && !bl2) {
                return -1;
            }
            if (bl && bl2) {
                return 0;
            }
            return 0;
        }
    };
    protected TreeMap<String, String> raw = new TreeMap(COMPARATOR);

    public String put(String string, int n) {
        return this.put(string, String.valueOf(n));
    }

    public String put(String string, long l) {
        return this.put(string, String.valueOf(l));
    }

    public String put(String string, double d) {
        return this.put(string, String.valueOf(d));
    }

    public String get(String string) {
        return this.raw.get(string);
    }

    public boolean containsKey(String string) {
        return this.raw.containsKey(string);
    }

    public synchronized String put(String string, String string2) {
        if (Util.empty(string)) {
            Log.i(HiidoReporter.TAG, String.format("report key is invalid for value %s", string2));
            return null;
        }
        string2 = Util.asEmptyOnNull(string2);
        return this.raw.put(string, string2);
    }

    public synchronized String put(String string, String string2, boolean bl) {
        if (Util.empty(string)) {
            Log.i(HiidoReporter.TAG, String.format("report key is invalid for value %s", string2));
            return null;
        }
        string2 = Util.asEmptyOnNull(string2);
        if (bl) {
            return this.raw.put(string, string2);
        }
        if (this.raw.containsKey(string)) {
            return this.raw.get(string);
        }
        return this.raw.put(string, string2);
    }

    public synchronized String getContent() {
        StringBuilder stringBuilder = new StringBuilder();
        TreeMap<String, String> treeMap = this.raw;
        for (Map.Entry<String, String> entry : treeMap.entrySet()) {
            String string = entry.getValue();
            if (Util.empty(string)) {
                Log.i(HiidoReporter.TAG, String.format("report No value for key %s", entry.getKey()));
                continue;
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            try {
                stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.i(HiidoReporter.TAG, String.format("report encoding fail for key %s", entry.getKey()));
            }
            stringBuilder.append("&");
        }
        if (stringBuilder.length() == 0) {
            Log.i(HiidoReporter.TAG, String.format("report Warn : http content may be null?", new Object[0]));
            stringBuilder = null;
            return null;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("hd_p=E&");
        }
        stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), "");
        String string = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder = null;
        return string;
    }

    public String toString() {
        return this.getContent();
    }

    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    public StatisContent copy() {
        StatisContent statisContent = new StatisContent();
        statisContent.raw = new TreeMap(COMPARATOR);
        statisContent.raw.putAll(this.raw);
        return statisContent;
    }
}

