/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared.statis;

import com.hummer.im._internals.shared.statis.Base64Util;
import com.hummer.im._internals.shared.statis.TextUtils;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesCipher {
    private static final int BLOCK_SIZE = 16;
    private static final String AES_CBC_NOPADDING = "AES/CBC/NoPadding";
    private static final ThreadLocal<Cipher> Cipher_AES_CBC_NOPADDING = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(AesCipher.AES_CBC_NOPADDING);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    };
    private final byte[] mkey;

    public AesCipher(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Key is null");
        }
        this.mkey = TextUtils.md5byte(byArray);
    }

    public String encryptTlogBytesBase64(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        byte[] byArray2 = this.encrypt(byArray);
        if (byArray2 == null) {
            throw new Exception("EncryptData is null");
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length + byArray2.length * 2);
        stringBuilder.append(TextUtils.length2DecimalChar(byArray.length));
        stringBuilder.append(Base64Util.encode(byArray2));
        return stringBuilder.toString();
    }

    public byte[] encrypt(byte[] byArray) {
        try {
            Cipher cipher = Cipher_AES_CBC_NOPADDING.get();
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.mkey, "AES");
            cipher.init(1, (Key)secretKeySpec, this.createIv());
            return cipher.doFinal(this.fillBlock(byArray));
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
    }

    private IvParameterSpec createIv() {
        byte[] byArray = new byte[this.mkey.length];
        System.arraycopy(this.mkey, 0, byArray, 0, this.mkey.length);
        return new IvParameterSpec(byArray);
    }

    private byte[] fillBlock(byte[] byArray) {
        int n = byArray.length % 16;
        if (n == 0) {
            return byArray;
        }
        int n2 = n == 0 ? byArray.length : byArray.length + 16 - n;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }
}

