/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.shared.ReflectionExt;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccess;
import com.hummer.im.model.completion.RichCompletion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceProvider {
    private static final String TAG = "ServiceProvider";
    private static boolean isLoaded = false;
    private static final HashMap<Class, Service> services = new HashMap();
    private static final HashMap<Class, Set<Class>> staticDependencies = new HashMap();
    private static final HashMap<Class, Set<Class>> dynamicDependencies = new HashMap();

    public static void openServices(final @Nullable RichCompletion richCompletion) {
        HMRContext.work.async("ServiceProvider::openServices", new Runnable(){

            @Override
            public void run() {
                List list = ServiceProvider.topologicalSort(dynamicDependencies);
                Log.i(ServiceProvider.TAG, Trace.once().method("openServices").msg(ServiceProvider.namesForServices(list)));
                ServiceProvider.openServices(list, 0, richCompletion);
            }
        });
    }

    public static void loadServicesIfNeeded(Context context, String string) {
        if (isLoaded) {
            return;
        }
        HMRContext.recorder.start("ServiceProvider::loadServicesIfNeeded:loadClasses");
        Set<Class<?>> set = ReflectionExt.loadClasses(context, "2.6.109", string, Object.class, new ReflectionExt.Filter(){

            @Override
            public boolean shouldAccept(String string) {
                String string2 = string.substring(string.lastIndexOf(".") + 1);
                return string2.startsWith("SP") && string2.endsWith("ModuleLoader");
            }
        });
        try {
            ServiceProvider.logLoadedModules(set);
            HMRContext.recorder.stop("ServiceProvider::loadServicesIfNeeded:loadClasses");
            HMRContext.recorder.start("ServiceProvider::loadServicesIfNeeded:registerServicesByModuleLoaders");
            ServiceProvider.registerServicesByModuleLoaders(set);
            HMRContext.recorder.stop("ServiceProvider::loadServicesIfNeeded:registerServicesByModuleLoaders");
        }
        catch (Exception exception) {
            Log.e(TAG, new Error(1000, "Fail loading services"), Trace.once().method("loadServicesIfNeeded").msg(exception.getLocalizedMessage()));
        }
        HMRContext.recorder.start("ServiceProvider::loadServicesIfNeeded:logDependencies");
        ServiceProvider.logDependencies("Static", staticDependencies);
        ServiceProvider.logDependencies("Dynamic", dynamicDependencies);
        HMRContext.recorder.stop("ServiceProvider::loadServicesIfNeeded:logDependencies");
        HMRContext.recorder.start("ServiceProvider::loadServicesIfNeeded:topologicalSort");
        final List<Service> list = ServiceProvider.topologicalSort(staticDependencies);
        HMRContext.recorder.stop("ServiceProvider::loadServicesIfNeeded:topologicalSort");
        if (list == null) {
            Log.e(TAG, Trace.once().method("loadServicesIfNeeded").info("sortedServices", list));
        }
        HMRContext.work.async("ServiceProvider::initService", new Runnable(){

            @Override
            public void run() {
                for (Service service : list) {
                    service.initService();
                    Log.i(ServiceProvider.TAG, Trace.once().method("initService").msg(ServiceProvider.simpleServiceName(service.getClass())));
                }
            }
        });
        isLoaded = true;
    }

    private static void registerServicesByModuleLoaders(Set<Class<?>> set) {
        for (Class<?> clazz : set) {
            ModuleLoader moduleLoader = (ModuleLoader)clazz.newInstance();
            if (moduleLoader == null) {
                Log.e(TAG, Trace.once().method("registerServicesByModuleLoaders").info("loader", moduleLoader));
            }
            moduleLoader.initModule();
            Map<Class, Service> map = moduleLoader.getServices();
            for (Map.Entry<Class, Service> entry : map.entrySet()) {
                ServiceProvider.register(entry.getKey(), entry.getValue());
            }
        }
    }

    private static void logLoadedModules(Set<Class<?>> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Class<?> clazz : set) {
            arrayList.add(ServiceProvider.simpleModuleName(clazz.getSimpleName()));
        }
        Log.i(TAG, Trace.once().method("loadedModules").msg(TextUtils.join((CharSequence)", ", arrayList)));
    }

    private static void logDependencies(String string, Map<Class, Set<Class>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("```mermaid\n").append("graph TD\n");
        for (Map.Entry<Class, Set<Class>> entry : map.entrySet()) {
            Class clazz = entry.getKey();
            if (entry.getValue().size() == 0) {
                stringBuilder.append(ServiceProvider.simpleServiceName(clazz)).append("\n");
            }
            for (Class clazz2 : entry.getValue()) {
                stringBuilder.append(ServiceProvider.simpleServiceName(clazz)).append("-->").append(ServiceProvider.simpleServiceName(clazz2)).append("\n");
            }
        }
        stringBuilder.append("```");
        Log.i(TAG, Trace.once().method("dependencies").msg("%s\n%s", string, stringBuilder.toString()));
    }

    private static String simpleServiceName(Class clazz) {
        String string = clazz.getSimpleName();
        if (string.endsWith("Service")) {
            string = string.substring(0, string.length() - "Service".length());
        }
        return string;
    }

    private static String namesForServices(List<Service> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Service service : list) {
            arrayList.add(service.getClass().getSimpleName());
        }
        return TextUtils.join((CharSequence)", ", arrayList);
    }

    private static String simpleModuleName(String string) {
        if (!string.startsWith("SP")) {
            Log.e(TAG, Trace.once().method("simpleModuleName").info("SP", string));
        }
        if (!string.endsWith("ModuleLoader")) {
            Log.e(TAG, Trace.once().method("simpleModuleName").info("ModuleLoader", string));
        }
        return string.substring(2, string.length() - 12);
    }

    private static void openServices(final List<Service> list, final int n, final RichCompletion richCompletion) {
        if (n >= list.size()) {
            CompletionUtils.dispatchSuccess(richCompletion);
            return;
        }
        final Service service = list.get(n);
        service.openService(new RichCompletion("ServiceProvider::openServices:" + service.getClass().getSimpleName()).onSuccess(new OnSuccess(){

            @Override
            public void onSuccess() {
                Log.i(ServiceProvider.TAG, Trace.once().method("openService").msg("Success - %s", service.getClass().getSimpleName()));
                ServiceProvider.openServices(list, n + 1, richCompletion);
            }
        }).onFailure(new OnFailure(){

            @Override
            public void onFailure(Error error) {
                Log.e(ServiceProvider.TAG, error, Trace.once().method("openService").msg("Failed - %s", service.getClass().getSimpleName()));
                for (int i = n - 1; i >= 0; --i) {
                    ((Service)list.get(i)).closeService();
                }
                CompletionUtils.dispatchFailure(richCompletion, error);
            }
        }));
    }

    public static void closeServices() {
        List<Service> list = ServiceProvider.topologicalSort(dynamicDependencies);
        Log.i(TAG, Trace.once().method("closeServices").msg(ServiceProvider.namesForServices(list)));
        Collections.reverse(list);
        for (Service service : list) {
            service.closeService();
            Log.i(TAG, Trace.once().method("closeService").msg(service.getClass().getSimpleName()));
        }
    }

    public static <Interface> Interface get(Class<Interface> clazz) {
        if (clazz == null) {
            Log.e(TAG, Trace.once().method("get").info("get", clazz));
        }
        for (Map.Entry<Class, Service> entry : services.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getKey())) continue;
            return (Interface)entry.getValue();
        }
        Service service = services.get(clazz);
        if (service == null) {
            Log.e(TAG, Trace.once().method("get").info("Service Not Found:", clazz.getName()));
        }
        return (Interface)service;
    }

    public static void register(Class<?> clazz, Service service) {
        services.put(clazz, service);
        staticDependencies.put(clazz, ServiceProvider.setFromArray(service.staticDependencies()));
        ServiceProvider.acquireDynamicDependencies(clazz).addAll(ServiceProvider.setFromArray(service.inherentDynamicDependencies()));
        for (Class clazz2 : ServiceProvider.setFromArray(service.plantingDynamicDependencies())) {
            ServiceProvider.acquireDynamicDependencies(clazz2).add(clazz);
        }
    }

    private static Set<Class> acquireDynamicDependencies(Class<?> clazz) {
        Set<Class> set = dynamicDependencies.get(clazz);
        if (set == null) {
            set = new HashSet<Class>();
            dynamicDependencies.put(clazz, set);
        }
        return set;
    }

    private static Set<Class> setFromArray(Class[] classArray) {
        if (classArray == null) {
            return new HashSet<Class>();
        }
        return new HashSet<Class>(Arrays.asList(classArray));
    }

    @NonNull
    private static List<Service> topologicalSort(Map<Class, Set<Class>> map) {
        Map<Class, Set<Class>> map2 = ServiceProvider.cloneDependencies(map);
        HashMap hashMap = new HashMap();
        int n = 0;
        for (Class arrayList22 : map2.keySet()) {
            hashMap.put(arrayList22, new HashSet());
        }
        ArrayList arrayList3 = new ArrayList();
        for (Map.Entry<Class, Set<Class>> entry : map2.entrySet()) {
            Iterator iterator = entry.getKey();
            for (Class clazz : entry.getValue()) {
                ((Set)hashMap.get(clazz)).add(iterator);
                ++n;
            }
            if (entry.getValue().size() != 0) continue;
            arrayList3.add(iterator);
        }
        ArrayList<Class> arrayList = new ArrayList<Class>();
        while (!arrayList3.isEmpty()) {
            Class clazz = (Class)arrayList3.remove(0);
            arrayList.add(clazz);
            for (Class clazz2 : (Set)hashMap.get(clazz)) {
                map2.get(clazz2).remove(clazz);
                --n;
                if (map2.get(clazz2).size() != 0) continue;
                arrayList3.add(clazz2);
            }
        }
        if (n != 0) {
            Log.e(TAG, Trace.once().method("topologicalSort").info("\u670d\u52a1\u4f9d\u8d56\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5b83\u4eec\u7684\u4f9d\u8d56\u5173\u7cfb", ""));
        }
        ArrayList<Service> arrayList2 = new ArrayList<Service>();
        for (Class clazz : arrayList) {
            arrayList2.add(services.get(clazz));
        }
        return arrayList2;
    }

    private static Map<Class, Set<Class>> cloneDependencies(Map<Class, Set<Class>> map) {
        HashMap<Class, Set<Class>> hashMap = new HashMap<Class, Set<Class>>();
        for (Map.Entry<Class, Set<Class>> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return hashMap;
    }

    public static interface Service {
        public Class[] staticDependencies();

        public Class[] inherentDynamicDependencies();

        public Class[] plantingDynamicDependencies();

        public void initService();

        public void openService(@NonNull RichCompletion var1);

        public void closeService();
    }

    public static interface ModuleLoader {
        public void initModule();

        public Map<Class, Service> getServices();
    }
}

