/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.shared;

import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import java.util.HashMap;
import java.util.Map;

public class CodecManager<DataType, DataValue, Model> {
    private static final String TAG = "CodecManager";
    private final Map<DataType, Codec<DataType, DataValue, Model>> type2codec = new HashMap<DataType, Codec<DataType, DataValue, Model>>();
    private final Map<Class<? extends Model>, Codec<DataType, DataValue, Model>> clazz2codec = new HashMap<Class<? extends Model>, Codec<DataType, DataValue, Model>>();

    public void register(Codec<DataType, DataValue, Model> codec) {
        DataType DataType = codec.getDataType();
        this.type2codec.put(DataType, codec);
        Class<Model> clazz = codec.getModelClass();
        this.clazz2codec.put(clazz, codec);
    }

    public DataType getDataType(Model Model) {
        Class<?> clazz = Model.getClass();
        Codec<DataType, DataValue, Model> codec = this.clazz2codec.get(clazz);
        if (codec == null) {
            Log.e(TAG, Trace.once().method("getDataType").msg("codec is null").info("model", Model).info("clazz", clazz).info("clazz2codec", this.clazz2codec));
            return null;
        }
        try {
            return codec.getDataType();
        }
        catch (Throwable throwable) {
            Log.e(TAG, Trace.once().method("encode").msg("Exception").info("model", Model).info("clazz", clazz).info("error", throwable.getMessage()));
            return null;
        }
    }

    public DataValue encode(Model Model) {
        Class<?> clazz = Model.getClass();
        Codec<DataType, DataValue, Model> codec = this.clazz2codec.get(clazz);
        if (codec == null) {
            Log.e(TAG, Trace.once().method("encode").msg("codec is null").info("model", Model).info("clazz", clazz).info("clazz2codec", this.clazz2codec));
            return null;
        }
        try {
            return codec.encode(Model);
        }
        catch (Throwable throwable) {
            Log.e(TAG, Trace.once().method("encode").msg("Exception").info("model", Model).info("clazz", clazz).info("error", throwable.getMessage()));
            return null;
        }
    }

    public Model decode(DataType DataType, DataValue DataValue) {
        Codec<DataType, DataValue, Model> codec = this.type2codec.get(DataType);
        if (codec == null) {
            Log.e(TAG, Trace.once().method("decode").msg("codec is null").info("type", DataType).info("data", DataValue).info("type2codec", this.type2codec.toString()));
            return null;
        }
        try {
            return codec.decode(DataValue);
        }
        catch (Throwable throwable) {
            Log.e(TAG, Trace.once().method("decode").msg("Exception").info("type", DataType).info("data", DataValue).info("error", throwable.getMessage()));
            return null;
        }
    }

    public static interface Codec<DataType, DataValue, Model> {
        public DataType getDataType();

        public Class<? extends Model> getModelClass();

        public Model decode(DataValue var1);

        public DataValue encode(Model var1);
    }
}

