/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.services.upload.YYaliOSS;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationToken;
import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.services.upload.YYaliOSS.GetOssTokenRequest;
import com.hummer.im._internals.services.upload.YYaliOSS.GetOssTokenResponse;
import com.hummer.im._internals.shared.StringChain;
import java.util.concurrent.CountDownLatch;

public final class GetOSSTokenMessage
extends IMRPC<GetOssTokenRequest, GetOssTokenRequest.Builder, GetOssTokenResponse> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final String region;
    private OSSFederationToken token = null;

    GetOSSTokenMessage(String string) {
        this.region = string;
    }

    @Override
    public String getHummerFunction() {
        return "GetOssToken";
    }

    @Override
    public void buildHummerRequest(@NonNull GetOssTokenRequest.Builder builder) {
        builder.setBucketPrefix("cim-" + this.region);
    }

    @Override
    public String describeHummerRequest(GetOssTokenRequest getOssTokenRequest) {
        return "region: " + this.region;
    }

    @Override
    public void handleHummerSuccess(@NonNull GetOssTokenResponse getOssTokenResponse) {
        this.token = new OSSFederationToken(getOssTokenResponse.getAk(), getOssTokenResponse.getSk(), getOssTokenResponse.getToken(), getOssTokenResponse.getExpiration());
        this.latch.countDown();
    }

    @Override
    public void handleHummerError(@Nullable GetOssTokenResponse getOssTokenResponse, @NonNull Error error) {
        this.latch.countDown();
    }

    @Override
    public String describeHummerResponse(@NonNull GetOssTokenResponse getOssTokenResponse) {
        return new StringChain().acceptNullElements().add("ak", getOssTokenResponse.getAk()).add("sk", getOssTokenResponse.getSk()).add("token", getOssTokenResponse.getToken()).add("expiration", getOssTokenResponse.getExpiration()).toString();
    }

    OSSFederationToken getCachedToken() {
        return this.token;
    }

    void waitUntilFinish() {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            Log.e("GetOSSTokenMessage", "send getOssTokenRequest latch await excepted,exceptionDesc:" + interruptedException.getMessage());
        }
    }
}

