/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.services.mq;

import android.os.Build;
import android.util.SparseIntArray;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.shared.HiidoReporter;
import com.hummer.im._internals.shared.IntenetUtil;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.id.User;
import com.hummer.im.service.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;

public final class StatisticsReporter {
    private static Map<Integer, String> codeNames = new HashMap<Integer, String>(){
        {
            this.put(Codes.ExceptionalDispatch, "ExceptionalDispatch");
            this.put(Codes.NotResetIsDraining, "NotResetIsDraining");
            this.put(Codes.ImpossibleScene, "ImpossibleScene");
        }
    };
    private static final String act = "cim2";
    public static SparseIntArray Frequencies = new SparseIntArray();
    private static SparseIntArray RequestedCounts = new SparseIntArray();
    private static final String TAG = "StatisticsReporter";
    private static CopyOnWriteArraySet<ReporterExtension> reporterExtensions = new CopyOnWriteArraySet();
    private static CopyOnWriteArraySet<ReceiverExtension> receiverExtensions = new CopyOnWriteArraySet();

    public static void report(final int n, final Fields fields) {
        boolean bl;
        final String string = codeNames.get(n);
        if (string == null) {
            return;
        }
        int n2 = Frequencies.get(n, 0);
        boolean bl2 = bl = n2 > 0;
        if (bl) {
            boolean bl3 = false;
            int n3 = RequestedCounts.get(n, 0);
            if (++n3 >= n2) {
                bl3 = true;
                n3 = 0;
            }
            RequestedCounts.put(n, n3);
            if (!bl3) {
                return;
            }
        }
        Log.w("MessageService", Trace.once().method("reportException").info("type", string).info("fields", fields.toString()));
        HashMap<String, HiidoReporter.Field> hashMap = new HashMap<String, HiidoReporter.Field>(){
            {
                this.put("errCode", HiidoReporter.Field.from(n));
                this.put("errType", HiidoReporter.Field.from(string));
                this.put("appId", HiidoReporter.Field.from(HMRContext.getAppId()));
                this.put("sys", HiidoReporter.Field.from(2L));
                this.put("operateSystem", HiidoReporter.Field.from(Build.VERSION.RELEASE));
                this.put("phoneModel", HiidoReporter.Field.from(StatisticsReporter.getDeviceName()));
                this.put("sdkver", HiidoReporter.Field.from(HMR.getVersion()));
                this.put("logId", HiidoReporter.Field.from(fields.mLogId));
                this.put("localSeqId", HiidoReporter.Field.from(fields.localSeqId));
                this.put("maxSeqId", HiidoReporter.Field.from(fields.maxSeqId));
                this.put("remoteSeqId", HiidoReporter.Field.from(fields.remoteSeqId));
                this.put("errInfo", HiidoReporter.Field.from(fields.errInfo));
            }
        };
        User user = HMR.getMe();
        if (user != null) {
            hashMap.put("uid", HiidoReporter.Field.from(user.getId()));
        }
        HiidoReporter.report(act, (Map<String, HiidoReporter.Field>)hashMap);
    }

    public static void report(Fields fields) {
        HashMap<String, HiidoReporter.Field> hashMap = new HashMap<String, HiidoReporter.Field>(){
            {
                this.put("appId", HiidoReporter.Field.from(HMRContext.appId));
                this.put("sys", HiidoReporter.Field.from(2L));
            }
        };
        User user = HMR.getMe();
        if (user != null) {
            hashMap.put("uid", HiidoReporter.Field.from(user.getId()));
        }
        hashMap.put("localSeqId", HiidoReporter.Field.from(fields.localSeqId));
        hashMap.put("maxSeqId", HiidoReporter.Field.from(fields.maxSeqId));
        hashMap.put("remoteSeqId", HiidoReporter.Field.from(fields.remoteSeqId));
        hashMap.put("errCode", HiidoReporter.Field.from(fields.errCode));
        hashMap.put("errInfo", HiidoReporter.Field.from(fields.errInfo));
        if (fields.errCode == Codes.UndefinedError) {
            hashMap.put("errType", HiidoReporter.Field.from("UndefinedError"));
        } else if (fields.errCode >= Codes.PullMsgNull && fields.errCode <= Codes.ParseMsgErr) {
            String[] stringArray = new String[]{"PullMsgNull", "LocalMaxRemote", "ContinuePullErr", "ParseMsgErr"};
            hashMap.put("errType", HiidoReporter.Field.from(stringArray[fields.errCode - 1]));
        }
        HiidoReporter.report(act, (Map<String, HiidoReporter.Field>)hashMap);
    }

    public static void report2SendMsg(Message message) {
        try {
            Integer n = StatisticsReporter.parseReportType(message);
            if (n.equals(ReliableType.DoNotReport)) {
                return;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(){
                {
                    this.put("appId", HiidoReporter.Field.from(HMRContext.appId).toString());
                }
            };
            User user = HMR.getMe();
            if (user != null) {
                hashMap.put("sUid", HiidoReporter.Field.from(user.getId()).toString());
            }
            hashMap.put("sdkVersion", HiidoReporter.Field.from(HMR.getVersion()).toString());
            hashMap.put("sNet", HiidoReporter.Field.from(IntenetUtil.getNetworkState()).toString());
            hashMap.put("sRegion", HiidoReporter.Field.from(HMRContext.region.area).toString());
            hashMap.put("sModel", HiidoReporter.Field.from(StatisticsReporter.getDeviceName()).toString());
            hashMap.put("rUid", HiidoReporter.Field.from(StatisticsReporter.parseReceiver(message)).toString());
            hashMap.put("msgUuid", HiidoReporter.Field.from(message.getUuid()).toString());
            hashMap.put("offline", HiidoReporter.Field.from(n).toString());
            HiidoReporter.reportAct("hmrp2psendmsg", null, null, (Map<String, String>)hashMap);
        }
        catch (Exception exception) {
            Log.e(TAG, "report error " + exception.toString());
        }
    }

    public static void report2RecvMsg(Message message) {
        try {
            Integer n = StatisticsReporter.parseReportType(message);
            if (n.equals(ReliableType.DoNotReport)) {
                return;
            }
            long l = HMR.getService(Channel.class).getAlignmentServerTS();
            if (l == 0L || message.getTimestamp() == 0L) {
                Log.i(TAG, Trace.once().method("reportMessage").info("continue report timestamp exception", message.getUuid()).info("timestamp", message.getTimestamp()));
            }
            long l2 = l - message.getTimestamp();
            StatisticsReporter.batchReportReturnCode("P2PMessageDelay", l2, 0);
            if (l2 <= 0L) {
                Log.i(TAG, Trace.once().method("reportMessage").info("continue report timestamp exception and recover", message.getUuid()).info("rtt", l2));
                l2 = 0L;
            }
            Log.d(TAG, Trace.once().method("reportMessageRTT").info("uuid", message.getUuid()).info("start timestamp", message.getTimestamp()).info("end timestamp", l).info("rtt", l2));
            HashMap<String, String> hashMap = new HashMap<String, String>(){
                {
                    this.put("appId", HiidoReporter.Field.from(HMRContext.appId).toString());
                }
            };
            User user = HMR.getMe();
            if (user != null) {
                hashMap.put("rUid", HiidoReporter.Field.from(user.getId()).toString());
            }
            if (message.getSender() != null) {
                hashMap.put("sUid", HiidoReporter.Field.from(message.getSender().getId()).toString());
            }
            hashMap.put("sdkVersion", HiidoReporter.Field.from(HMR.getVersion()).toString());
            hashMap.put("rNet", HiidoReporter.Field.from(IntenetUtil.getNetworkState()).toString());
            hashMap.put("rRegion", HiidoReporter.Field.from(HMRContext.region.area).toString());
            hashMap.put("rModel", HiidoReporter.Field.from(StatisticsReporter.getDeviceName()).toString());
            hashMap.put("msgUuid", HiidoReporter.Field.from(message.getUuid()).toString());
            hashMap.put("offline", HiidoReporter.Field.from(n).toString());
            hashMap.put("msgCost", HiidoReporter.Field.from(l2).toString());
            HiidoReporter.reportAct("hmrp2precvmsg", null, null, (Map<String, String>)hashMap);
        }
        catch (Exception exception) {
            Log.e(TAG, "report error " + exception.toString());
        }
    }

    public static void batchReportReturnCode(String string, long l, int n) {
        HiidoReporter.batchReportReturnCode(string, l, n);
    }

    public static void registerReporterExtension(ReporterExtension reporterExtension) {
        reporterExtensions.add(reporterExtension);
    }

    public static void unRegisterReporterExtension(ReporterExtension reporterExtension) {
        reporterExtensions.remove(reporterExtension);
    }

    public static void registerReceiverExtension(ReceiverExtension receiverExtension) {
        receiverExtensions.add(receiverExtension);
    }

    public static void unRegisterReceiverExtension(ReceiverExtension receiverExtension) {
        receiverExtensions.remove(receiverExtension);
    }

    private static Integer parseReportType(Message message) {
        for (ReporterExtension reporterExtension : reporterExtensions) {
            Integer n = reporterExtension.parseReportType(message);
            if (n == null) continue;
            return n;
        }
        return ReliableType.DoNotReport;
    }

    private static Long parseReceiver(Message message) {
        for (ReceiverExtension receiverExtension : receiverExtensions) {
            Long l = receiverExtension.parseReceiver(message);
            if (l == null) continue;
            return l;
        }
        return message.getReceiver().getId();
    }

    private static String getDeviceName() {
        String string = Build.MODEL;
        String string2 = Build.MANUFACTURER;
        return string.startsWith(string2) ? StatisticsReporter.capitalizedPhrase(string) : StatisticsReporter.capitalizedPhrase(string2) + " " + string;
    }

    private static String capitalizedPhrase(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (char c : string.toCharArray()) {
            if (bl && Character.isLetter(c) || Character.isWhitespace(c)) {
                c = Character.toUpperCase(c);
                bl = Character.isWhitespace(c);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static class Fields {
        public int errCode;
        public Long mLogId;
        public Long localSeqId;
        public Long remoteSeqId;
        public Long maxSeqId;
        public String errInfo;

        public Fields(int n) {
            this.errCode = n;
        }

        public Fields() {
        }

        public void setLocalSeqId(Long l) {
            this.localSeqId = l;
        }

        public void setRemoteSeqId(Long l) {
            this.remoteSeqId = l;
        }

        public void setMaxSeqId(Long l) {
            this.maxSeqId = l;
        }

        public void setErrInfo(String string) {
            this.errInfo = string;
        }
    }

    public static final class ReliableType {
        public static final Integer DoNotReport = -1;
        public static final Integer UnReliable = 0;
        public static final Integer Reliable = 1;
    }

    public static final class Codes {
        public static final Integer PullMsgNull = 1;
        public static final Integer LocalMaxRemote = 2;
        public static final Integer ContinuePullErr = 3;
        public static final Integer ParseMsgErr = 4;
        public static final Integer ExceptionalDispatch = 5;
        public static final Integer NotResetIsDraining = 6;
        public static final Integer ImpossibleScene = 7;
        public static final Integer UndefinedError = 999;
    }

    public static interface ReceiverExtension {
        public Long parseReceiver(Message var1);
    }

    public static interface ReporterExtension {
        public Integer parseReportType(Message var1);
    }
}

