/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.roaming;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.chatsvc.MessageParser;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.History;
import com.hummer.im._internals.roaming.RPCFetchRemoteMessage;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.chat.Message;
import com.hummer.im.model.chat.store.FetchingClauses;
import com.hummer.im.model.chat.store.FetchingResult;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccessArg;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.service.Channel;
import com.hummer.im.service.RoamingService;
import java.util.ArrayList;

public class RoamingServiceImpl
implements ServiceProvider.Service,
RoamingService {
    private static final String TAG = "RoamingServiceImpl";

    @Override
    public Class[] staticDependencies() {
        return null;
    }

    @Override
    public Class[] inherentDynamicDependencies() {
        return new Class[]{Channel.class};
    }

    @Override
    public Class[] plantingDynamicDependencies() {
        return null;
    }

    @Override
    public void initService() {
    }

    @Override
    public void openService(@NonNull RichCompletion richCompletion) {
        CompletionUtils.dispatchSuccess(richCompletion);
    }

    @Override
    public void closeService() {
    }

    @Override
    public void fetchMessages(Identifiable identifiable, FetchingClauses fetchingClauses, HMR.CompletionArg<FetchingResult> completionArg) {
        final RichCompletionArg<FetchingResult> richCompletionArg = new RichCompletionArg<FetchingResult>(completionArg, "RoamingService::fetchMessages");
        Error error = null;
        if (HMR.getState() != HMR.State.Opened || HMR.getMe().isAnonymous()) {
            error = new Error(1011, "Hummer not open, or using anonymous mode");
        }
        if (fetchingClauses == null) {
            error = new Error(1002, "clauses should not be null");
        } else if (identifiable == null) {
            error = new Error(1002, "<target> should not be null");
        }
        if (error != null) {
            Log.e(TAG, Trace.once().method("fetchRambleMessages").msg(error.toString()));
            CompletionUtils.dispatchFailure(richCompletionArg, error);
            return;
        }
        if (fetchingClauses.getBeforeTimestamp() == null) {
            fetchingClauses.setBeforeTimestamp(0L);
        }
        int n = 100;
        if (fetchingClauses.getLimit() == null || fetchingClauses.getLimit() > n) {
            fetchingClauses.setLimit(n);
        } else if (fetchingClauses.getLimit() < 1) {
            fetchingClauses.setLimit(1);
        }
        HMR.getService(Channel.class).run(new RPCFetchRemoteMessage(identifiable, fetchingClauses, new RichCompletionArg<History.ReverseListChatHistoryResponse>("RoamingService::RPCFetchRemoteMessage").onSuccess(new OnSuccessArg<History.ReverseListChatHistoryResponse>(){

            @Override
            public void onSuccess(History.ReverseListChatHistoryResponse reverseListChatHistoryResponse) {
                ArrayList<Message> arrayList = new ArrayList<Message>();
                for (History.HistoryMsg historyMsg : reverseListChatHistoryResponse.getMsgsList()) {
                    Message message = RoamingServiceImpl.this.parseMsg(historyMsg);
                    if (message == null) continue;
                    arrayList.add(RoamingServiceImpl.this.parseMsg(historyMsg));
                }
                FetchingResult fetchingResult = new FetchingResult();
                fetchingResult.setHasMore(reverseListChatHistoryResponse.getHasMore());
                fetchingResult.setNextTimestamp(reverseListChatHistoryResponse.getNextTimestamp());
                fetchingResult.setMessages(arrayList);
                CompletionUtils.dispatchSuccess(richCompletionArg, fetchingResult);
            }
        }).onFailure(new OnFailure(){

            @Override
            public void onFailure(Error error) {
                CompletionUtils.dispatchFailure(richCompletionArg, error);
            }
        })));
    }

    private Message parseMsg(History.HistoryMsg historyMsg) {
        return MessageParser.parseContent(historyMsg.getContent(), historyMsg.getTimestamp(), historyMsg.getAction());
    }
}

