/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.roaming;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.protobuf.GeneratedMessageLite;
import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.chatsvc.IdentifiableHelper;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.History;
import com.hummer.im._internals.proto.Im;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.store.FetchingClauses;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.Identifiable;
import java.util.ArrayList;

public class RPCFetchRemoteMessage
extends IMRPC<History.ReverseListChatHistoryRequest, History.ReverseListChatHistoryRequest.Builder, History.ReverseListChatHistoryResponse> {
    private static final String TAG = "RPCFetchRemoteMessage";
    private final Identifiable target;
    private final FetchingClauses clauses;
    private final RichCompletionArg<History.ReverseListChatHistoryResponse> completion;

    RPCFetchRemoteMessage(@NonNull Identifiable identifiable, @NonNull FetchingClauses fetchingClauses, RichCompletionArg<History.ReverseListChatHistoryResponse> richCompletionArg) {
        this.target = identifiable;
        this.clauses = fetchingClauses;
        this.completion = richCompletionArg;
    }

    @Override
    public void buildHummerRequest(@NonNull History.ReverseListChatHistoryRequest.Builder builder) {
        ArrayList<GeneratedMessageLite> arrayList = new ArrayList<GeneratedMessageLite>();
        if (this.clauses.getSenders() != null && this.clauses.getSenders().size() > 0) {
            for (Identifiable object : this.clauses.getSenders()) {
                arrayList.add(Im.ID.newBuilder().setId(object.getId()).setIdType(IdentifiableHelper.makeStringFrom(object)).build());
            }
        }
        ArrayList arrayList2 = new ArrayList();
        if (this.clauses.getMessageTypes() != null && this.clauses.getMessageTypes().size() > 0) {
            for (Class<Content> clazz : this.clauses.getMessageTypes()) {
                try {
                    arrayList2.add(Content.getDataType(clazz.newInstance()));
                }
                catch (InstantiationException illegalAccessException) {
                    Log.e(TAG, Trace.once().method("buildHummerRequest").info("msg", "InstantiationException").info("exception", illegalAccessException));
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e(TAG, Trace.once().method("buildHummerRequest").info("msg", "IllegalAccessException").info("exception", illegalAccessException));
                }
            }
        }
        ((History.ReverseListChatHistoryRequest)builder.setBeginTimestamp(this.clauses.getBeforeTimestamp()).setLimit(this.clauses.getLimit()).setToIdType(IdentifiableHelper.makeStringFrom(this.target)).setToId(this.target.getId()).addAllFromIds(arrayList).addAllMsgTypes(arrayList2).build()).toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull History.ReverseListChatHistoryResponse reverseListChatHistoryResponse) {
        CompletionUtils.dispatchSuccess(this.completion, reverseListChatHistoryResponse);
    }

    @Override
    public void handleHummerError(@Nullable History.ReverseListChatHistoryResponse reverseListChatHistoryResponse, @NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, error);
    }

    @Override
    public String describeHummerResponse(@NonNull History.ReverseListChatHistoryResponse reverseListChatHistoryResponse) {
        return "has_more:" + reverseListChatHistoryResponse.getHasMore() + ", log_id:" + reverseListChatHistoryResponse.getLogId() + ", msg:" + reverseListChatHistoryResponse.getMsg() + ", msgs.size:" + reverseListChatHistoryResponse.getMsgsList().size();
    }

    @Override
    public String getHummerFunction() {
        return "ReverseListChatHistory";
    }
}

