/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.mq;

import android.content.SharedPreferences;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.Objects;
import com.hummer.im._internals.PrefStorage;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.RPCCheckGrpSysMsgIntegrity;
import com.hummer.im._internals.mq.RPCCheckMsgIntegrity;
import com.hummer.im._internals.mq.RPCFetchPrivateMaxSeqId;
import com.hummer.im._internals.mq.RPCFetchPrivateSeqId;
import com.hummer.im._internals.mq.RPCFetchSharedMaxSeqId;
import com.hummer.im._internals.mq.RPCFetchSharedSeqId;
import com.hummer.im._internals.mq.RPCPullPrivateMessages;
import com.hummer.im._internals.mq.RPCPullSharedMessages;
import com.hummer.im._internals.mq.RPCReportPrivateSeqId;
import com.hummer.im._internals.mq.RPCReportSharedSeqId;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.proto.Push;
import com.hummer.im._internals.services.mq.RPCPullingResponse;
import com.hummer.im._internals.services.mq.StatisticsReporter;
import com.hummer.im._internals.shared.HiidoReporter;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccessArg;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.service.Channel;
import com.hummer.im.service.MQService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Locale;

public final class Source
implements MQService.Source {
    private final Mode mode;
    private Long seqId;
    private Long lastPullAt;
    private boolean isDraining;
    private boolean sourceChanged;
    private static final long TimeoutDuration = 10000L;
    private static final long DEFAULT_PULLING_PERIOD = 900000L;

    public Source(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public void onTimerPulse(final MQService.MessagesDispatcher messagesDispatcher) {
        HMRContext.work.async("Source::onTimerPulse:" + this.mode.sourceName(), new Runnable(){

            @Override
            public void run() {
                if (Source.this.isOverdue(Source.this.mode.getPullingPeriod())) {
                    if (Source.this.isDraining) {
                        StatisticsReporter.report(StatisticsReporter.Codes.NotResetIsDraining, new StatisticsReporter.Fields());
                    }
                    Source.this.isDraining = false;
                }
                Source.this.drainMessagesIfNeeded(messagesDispatcher);
            }
        });
    }

    @Override
    public void onManualPullingRequest(final MQService.MessagesDispatcher messagesDispatcher) {
        HMRContext.work.async("Source::onManualPullingRequest", new Runnable(){

            @Override
            public void run() {
                Source.this.drainMessagesIfNeeded(messagesDispatcher);
            }
        });
    }

    @Override
    public void onNetworkReconnected(final MQService.MessagesDispatcher messagesDispatcher) {
        HMRContext.work.async("Source::onNetworkReconnected", new Runnable(){

            @Override
            public void run() {
                Source.this.lastPullAt = null;
                Source.this.drainMessagesIfNeeded(messagesDispatcher);
            }
        });
    }

    @Override
    public void start(final MQService.MessagesDispatcher messagesDispatcher) {
        HMRContext.work.async("Source::start", new Runnable(){

            @Override
            public void run() {
                Source.this.performStarting(messagesDispatcher);
            }
        });
    }

    @Override
    public void stop() {
        HMRContext.work.async("Source::stop", new Runnable(){

            @Override
            public void run() {
                Source.this.performStopping();
            }
        });
    }

    public String toString() {
        return this.mode.sourceName();
    }

    public void checkIntegrity(final Im.Msg msg) {
        HiidoReporter.reportQueue.async("", new Runnable(){

            @Override
            public void run() {
                if (!Source.this.mode.isCheckIntegrity()) {
                    return;
                }
                if (Source.this.mode.getCheckTermId() != null && Source.this.mode.getCheckIntegritySeqId() != null && Source.this.mode.getCheckTermId().compareTo(msg.getTerm()) == 0 && Source.this.mode.getCheckIntegritySeqId() + 1 != msg.getIntegrityCheckSeq()) {
                    if (HMRContext.region != null) {
                        Source.this.mode.checkIntegrityRequest(msg);
                    } else {
                        Log.w(Source.this.mode.sourceName(), Trace.once().msg("did not call checkIntegrityRequest\uff0cbecz region is null"));
                    }
                }
                Source.this.mode.updateParam(msg);
            }
        });
    }

    private void performStarting(final MQService.MessagesDispatcher messagesDispatcher) {
        Log.i(this.mode.sourceName(), Trace.once().method("performStarting"));
        this.isDraining = false;
        this.lastPullAt = null;
        this.mode.start(new Mode.NotifyHandler(){

            @Override
            public void onNotify(final long l, final Im.Msg msg, final long l2) {
                HMRContext.work.async("", new Runnable(){

                    @Override
                    public void run() {
                        if (msg == null) {
                            Source.this.sourceChanged = true;
                            Source.this.drainMessagesIfNeeded(messagesDispatcher);
                            return;
                        }
                        Log.i(Source.this.mode.sourceName(), Trace.once().method("onNotify").info("prevSeqId", l).info("seq", l2).info("draining", Source.this.isDraining).info("localSeqId", Source.this.seqId));
                        if (Source.this.seqId == null || Source.this.isDraining || l == 0L) {
                            return;
                        }
                        if (l == Source.this.seqId) {
                            Log.i(Source.this.mode.sourceName(), Trace.once().method("onNotify: Accept msg"));
                            ArrayList<Im.Msg> arrayList = new ArrayList<Im.Msg>();
                            arrayList.add(msg);
                            messagesDispatcher.dispatch(arrayList, Source.this);
                            Source.this.lastPullAt = System.currentTimeMillis();
                            Source.this.setSeqId(l2, true);
                        } else {
                            Log.i(Source.this.mode.sourceName(), Trace.once().method("onNotify: Pull missing msgs"));
                            Source.this.sourceChanged = true;
                            Source.this.drainMessagesIfNeeded(messagesDispatcher);
                        }
                    }
                });
            }
        });
        this.mode.loadSeqId(this.getStrategy(this.mode), new RichCompletionArg<Long>("Source::loadSeqId:" + this.mode.sourceName()).onSuccess(new OnSuccessArg<Long>(){

            @Override
            public void onSuccess(final Long l) {
                if (l == null) {
                    Log.e("Source", Trace.once().method("performStarting").msg("loadedSeqId is <null>"));
                }
                HMRContext.work.async(Source.this.mode.sourceName() + "::loadSeqIdSuccess", new Runnable(){

                    @Override
                    public void run() {
                        Source.this.setSeqId(l, Source.this.seqId == null);
                        Source.this.drainMessagesIfNeeded(messagesDispatcher);
                    }
                });
            }
        }).onFailure(new OnFailure(){

            @Override
            public void onFailure(Error error) {
                HMRContext.work.async(Source.this.mode.sourceName() + "::loadSeqIdFailure", new Runnable(){

                    @Override
                    public void run() {
                        Source.this.setSeqId(0L, false);
                        Source.this.drainMessagesIfNeeded(messagesDispatcher);
                    }
                });
            }
        }));
    }

    private MQService.FetchStrategy getStrategy(Mode mode) {
        if (mode.getStrategy() != null) {
            return mode.getStrategy();
        }
        if (HMR.getService(MQService.class).getFetchStrategy() != null) {
            return HMR.getService(MQService.class).getFetchStrategy();
        }
        return MQService.FetchStrategy.Continuously;
    }

    private void performStopping() {
        Log.i(this.mode.sourceName(), Trace.once().method("performStopping"));
        this.mode.stop();
        this.isDraining = false;
        this.lastPullAt = null;
        this.seqId = null;
    }

    private boolean isOverdue(long l) {
        long l2 = l / 30L;
        long l3 = System.currentTimeMillis();
        return this.lastPullAt == null || l3 - this.lastPullAt >= l - l2;
    }

    private void drainMessagesIfNeeded(MQService.MessagesDispatcher messagesDispatcher) {
        boolean bl;
        boolean bl2 = bl = this.seqId == null || this.isDraining || !this.sourceChanged && !this.isOverdue(this.mode.getPullingPeriod());
        if (bl) {
            return;
        }
        Log.i(this.mode.sourceName(), Trace.once().method("drainMessagesIfNeeded").info("seqId", this.seqId).info("changed", this.sourceChanged).info("draining", this.isDraining).info("overdue", this.isOverdue(this.mode.getPullingPeriod())));
        this.sourceChanged = false;
        this.isDraining = true;
        this.drainMessages(messagesDispatcher, this.seqId, this.lastPullAt == null, new Runnable(){

            @Override
            public void run() {
                Source.this.isDraining = false;
            }
        });
    }

    private void drainMessages(final MQService.MessagesDispatcher messagesDispatcher, final long l, final boolean bl, final Runnable runnable) {
        Log.i(this.mode.sourceName(), Trace.once().method("drainMessages").info("fromSeqId", l).info("isFirstDrain", bl));
        HMR.getService(Channel.class).run(this.mode.createPullingRequest(l, bl, new RichCompletionArg<RPCPullingResponse>("Source::createPullingRequest:" + this.mode.sourceName()).onSuccess(new OnSuccessArg<RPCPullingResponse>(){

            @Override
            public void onSuccess(final RPCPullingResponse rPCPullingResponse) {
                HMRContext.work.async("", new Runnable(){

                    @Override
                    public void run() {
                        if (Source.this.seqId == null) {
                            Log.i(Source.this.mode.sourceName(), Trace.once().method("drainMessages").msg("seqId is null, return"));
                            return;
                        }
                        ArrayList<Im.Msg> arrayList = new ArrayList<Im.Msg>();
                        for (Im.Msg msg : rPCPullingResponse.messages) {
                            if (msg.getSeqId() <= Source.this.seqId) {
                                Log.i(Source.this.mode.sourceName(), Trace.once().method("handleDrainingSuccess").msg("BUGGY!! abandon message").info("lastPullAt -> ", Source.this.lastPullAt).info("localSeqid", Source.this.seqId).info("msgSeqid", msg.getSeqId()));
                                continue;
                            }
                            arrayList.add(msg);
                        }
                        if (rPCPullingResponse.messages.size() > 0 && arrayList.size() <= 0) {
                            Log.i(Source.this.mode.sourceName(), Trace.once().method("handleDrainingSuccess").msg("BUGGY!! abandon messages").info("lastPullAt -> ", Source.this.lastPullAt).info("localSeqid", Source.this.seqId).info("maxSeqid", rPCPullingResponse.maxSeqId).info("msgSize", rPCPullingResponse.messages.size()));
                            runnable.run();
                            return;
                        }
                        if (arrayList.size() > 0) {
                            try {
                                messagesDispatcher.dispatch(arrayList, Source.this);
                            }
                            catch (Throwable throwable) {
                                Log.e(Source.this.mode.sourceName(), Trace.once().method("handleDrainingSuccess").msg("Exception while dispatching messages").info("exception", throwable.getLocalizedMessage()));
                                StatisticsReporter.report(StatisticsReporter.Codes.ExceptionalDispatch, new StatisticsReporter.Fields(){
                                    {
                                        StringWriter stringWriter = new StringWriter();
                                        throwable.printStackTrace(new PrintWriter(stringWriter));
                                        this.errInfo = stringWriter.toString();
                                    }
                                });
                            }
                        }
                        Source.this.lastPullAt = System.currentTimeMillis();
                        Log.i(Source.this.mode.sourceName(), Trace.once().method("handleDrainingSuccess").msg("lastPullAt -> " + Source.this.lastPullAt));
                        if (rPCPullingResponse.maxSeqId != null) {
                            Source.this.setSeqId(rPCPullingResponse.maxSeqId, true);
                            if (rPCPullingResponse.hasMore) {
                                Source.this.drainMessages(messagesDispatcher, rPCPullingResponse.maxSeqId, bl, runnable);
                            } else {
                                runnable.run();
                            }
                        } else if (!rPCPullingResponse.hasMore) {
                            runnable.run();
                        } else {
                            Log.e(Source.this.mode.sourceName(), Trace.once().method("handleDrainingSuccess").msg("BUGGY!! \u672a\u77e5\u573a\u666f\uff0chasMore\u4e3aTrue, \u4f46maxSeqId\u4e3anull\uff0c\u65e0\u6cd5\u786e\u5b9a\u4e0b\u6b21\u62c9\u53d6\u4ece\u54ea\u5f00\u59cb"));
                            runnable.run();
                            StatisticsReporter.report(StatisticsReporter.Codes.ImpossibleScene, new StatisticsReporter.Fields(){
                                {
                                    this.errInfo = String.format(Locale.US, "hasMore\u4e3aTrue, \u4f46maxSeqId\u4e3anull\uff0c\u65e0\u6cd5\u786e\u5b9a\u4e0b\u6b21\u62c9\u53d6\u4ece\u54ea\u5f00\u59cb\u3002fromSeqId: %d", l);
                                }
                            });
                        }
                    }
                });
            }
        }).onFailure(new OnFailure(){

            @Override
            public void onFailure(Error error) {
                HMRContext.work.async("Source::RPCPullingResponse:failure", runnable);
            }
        })));
    }

    private void setSeqId(Long l, boolean bl) {
        if (this.seqId != null && this.seqId.equals(l)) {
            return;
        }
        Log.i(this.mode.sourceName(), Trace.once().method("setSeqId").msg("%d -> %d", this.seqId, l));
        if (bl) {
            this.mode.storeSeqId(l);
        }
        this.seqId = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Source source = (Source)object;
        return this.mode.equals(source.mode);
    }

    public int hashCode() {
        return this.mode.hashCode();
    }

    public static class Shared
    implements Mode {
        private static final String PrefKeySeqID = "_group_sys_seqid";
        private final long groupId;
        private final String topic;
        private final String area;
        private Channel.NotificationHandler sharedHandler;
        private MQService.FetchStrategy strategy;
        private long pullingPeriod;
        private Long checkTermId;
        private Integer checkIntegritySeqId;
        private long checkLastSeqId;
        private boolean isCheckIntegrity = false;

        public Shared(long l, String string) {
            this(l, string, null);
        }

        public Shared(long l, String string, String string2) {
            this(l, string, string2, null);
        }

        public Shared(long l, String string, String string2, MQService.FetchStrategy fetchStrategy) {
            this(l, string, string2, fetchStrategy, 900000L);
        }

        public Shared(long l, String string, String string2, MQService.FetchStrategy fetchStrategy, long l2) {
            this.groupId = l;
            this.topic = string == null ? "" : string;
            this.area = string2;
            this.strategy = fetchStrategy;
            this.pullingPeriod = l2 < 1L ? 900000L : l2;
        }

        @Override
        public void setCheckIntegrity(boolean bl) {
            this.isCheckIntegrity = bl;
        }

        @Override
        public Long getCheckTermId() {
            return this.checkTermId;
        }

        @Override
        public Integer getCheckIntegritySeqId() {
            return this.checkIntegritySeqId;
        }

        @Override
        public boolean isCheckIntegrity() {
            return this.isCheckIntegrity;
        }

        @Override
        public void updateParam(Im.Msg msg) {
            this.checkTermId = msg.getTerm();
            this.checkIntegritySeqId = msg.getIntegrityCheckSeq();
            this.checkLastSeqId = msg.getSeqId();
        }

        @Override
        public MQService.FetchStrategy getStrategy() {
            return this.strategy;
        }

        @Override
        public long getPullingPeriod() {
            return this.pullingPeriod;
        }

        @Override
        public String sourceName() {
            return "SharedSource(" + this.groupId + "," + this.topic + ")";
        }

        @Override
        public String topicName() {
            return this.topic;
        }

        @Override
        public void loadSeqId(MQService.FetchStrategy fetchStrategy, RichCompletionArg<Long> richCompletionArg) {
            Long l = null;
            if (fetchStrategy == MQService.FetchStrategy.Continuously) {
                l = PrefStorage.storage().execute(new PrefStorage.Query<Long>(){

                    @Override
                    public Long run(SharedPreferences sharedPreferences) {
                        if (sharedPreferences == null) {
                            return null;
                        }
                        long l = sharedPreferences.getLong(Shared.this.prefKey(), -1L);
                        if (l == -1L) {
                            return null;
                        }
                        return l;
                    }
                });
            } else if (fetchStrategy == MQService.FetchStrategy.ReloadHistories) {
                l = 0L;
            }
            Log.i(this.sourceName(), Trace.once().method("loadSeqId").info("seqId", l));
            if (l == null) {
                if (fetchStrategy == MQService.FetchStrategy.IgnoreBefore) {
                    this.fetchMaxSeqId(3, this.topic, richCompletionArg);
                } else {
                    this.fetchSeqId(3, this.topic, richCompletionArg);
                }
            } else {
                CompletionUtils.dispatchSuccess(richCompletionArg, l);
            }
        }

        private void fetchSeqId(final int n, final String string, final RichCompletionArg<Long> richCompletionArg) {
            Log.i(this.sourceName(), Trace.once().method("Shared fetchSeqId"));
            if (n <= 0) {
                CompletionUtils.dispatchFailure(richCompletionArg, new Error(1005, "Shared Failed fetching seqId: " + string));
                return;
            }
            HMR.getService(Channel.class).run(new RPCFetchSharedSeqId(string, this.area, this.groupId, new RichCompletionArg<Long>("Source::RPCFetchSharedSeqId" + string).onSuccess(new OnSuccessArg<Long>(){

                @Override
                public void onSuccess(Long l) {
                    CompletionUtils.dispatchSuccess(richCompletionArg, l);
                }
            }).onFailure(new OnFailure(){

                @Override
                public void onFailure(Error error) {
                    if (error != null && error.code != 1005) {
                        CompletionUtils.dispatchFailure(richCompletionArg, error);
                    } else {
                        HMRContext.work.asyncAfter("Source::repeatFetchSeqId", 3000, new Runnable(){

                            @Override
                            public void run() {
                                Shared.this.fetchSeqId(n - 1, string, richCompletionArg);
                            }
                        });
                    }
                }
            })));
        }

        private void fetchMaxSeqId(final int n, final String string, final RichCompletionArg<Long> richCompletionArg) {
            Log.i(this.sourceName(), Trace.once().method("Shared fetchMaxSeqId"));
            if (n <= 0) {
                CompletionUtils.dispatchFailure(richCompletionArg, new Error(1005, "Shared Failed fetching maxSeqId: " + string));
                return;
            }
            HMR.getService(Channel.class).run(new RPCFetchSharedMaxSeqId(string, this.groupId, this.area, new RichCompletionArg<Long>("Source::RPCFetchSharedMaxSeqId" + string).onSuccess(new OnSuccessArg<Long>(){

                @Override
                public void onSuccess(Long l) {
                    CompletionUtils.dispatchSuccess(richCompletionArg, l);
                }
            }).onFailure(new OnFailure(){

                @Override
                public void onFailure(Error error) {
                    if (error != null && error.code != 1005) {
                        CompletionUtils.dispatchFailure(richCompletionArg, error);
                    } else {
                        HMRContext.work.asyncAfter("Source::repeatFetchMaxSeqId", 3000, new Runnable(){

                            @Override
                            public void run() {
                                Shared.this.fetchMaxSeqId(n - 1, string, richCompletionArg);
                            }
                        });
                    }
                }
            })));
        }

        @Override
        public void storeSeqId(final long l) {
            PrefStorage.storage().execute(new PrefStorage.Edit(){

                @Override
                public void run(SharedPreferences.Editor editor) {
                    editor.putLong(Shared.this.prefKey(), l);
                }
            });
            HMR.getService(Channel.class).run(new RPCReportSharedSeqId(this.topic, this.area, this.groupId, l, null));
        }

        @Override
        public Channel.RPC createPullingRequest(long l, boolean bl, RichCompletionArg<RPCPullingResponse> richCompletionArg) {
            return new RPCPullSharedMessages(this.groupId, this.topic, this.area, l, 200, bl, richCompletionArg);
        }

        @Override
        public void checkIntegrityRequest(Im.Msg msg) {
            HMR.getService(Channel.class).run(new RPCCheckGrpSysMsgIntegrity(this.groupId, this.topic, this.checkLastSeqId, msg.getSeqId(), 0, null));
        }

        @Override
        public void start(final Mode.NotifyHandler notifyHandler) {
            Log.i(this.sourceName(), Trace.once().method("start"));
            this.sharedHandler = new Channel.NotificationHandler(){

                @Override
                public void onNotify(String string, String string2, final byte[] byArray) {
                    String string3 = "service_api_gateway/cim.proto.PushService.IMPushGroupSysMsg";
                    String string4 = string + '/' + string2;
                    if (!string3.equals(string4)) {
                        return;
                    }
                    HMRContext.work.async("SharedSource::onNotify", new Runnable(){

                        @Override
                        public void run() {
                            this.handleNotify(byArray);
                        }
                    });
                }

                public String toString() {
                    return Shared.this.sourceName();
                }

                private void handleNotify(byte[] byArray) {
                    Push.IMPushGroupSysMsgRequest iMPushGroupSysMsgRequest;
                    try {
                        iMPushGroupSysMsgRequest = (Push.IMPushGroupSysMsgRequest)((Push.IMPushGroupSysMsgRequest.Builder)Push.IMPushGroupSysMsgRequest.newBuilder().mergeFrom(byArray)).build();
                    }
                    catch (Throwable throwable) {
                        Log.e(Shared.this.sourceName(), Trace.once("Failed parsing IMPushGroupSysMsgRequest").info("Exception", throwable));
                        return;
                    }
                    if (iMPushGroupSysMsgRequest.getEnvName() != null && !iMPushGroupSysMsgRequest.getEnvName().isEmpty()) {
                        if (HMRContext.region == null) {
                            Log.w(Shared.this.sourceName(), Trace.once().method("onNotify").msg("localEnv is null"));
                            return;
                        }
                        HMRContext.Region region = HMRContext.region;
                        String string = String.format(Locale.US, "%s_%s_%s", region.type, region.name, Shared.this.getArea() == null ? region.area : Shared.this.getArea());
                        String string2 = String.format(Locale.US, "%s_%s_%s", iMPushGroupSysMsgRequest.getEnvType(), iMPushGroupSysMsgRequest.getEnvName(), HMRContext.Region.getArea(iMPushGroupSysMsgRequest.getRegion()));
                        if (!Objects.equals(string2, string)) {
                            Log.i(Shared.this.sourceName(), Trace.once().method("onNotify").msg("Ignored notify of different env").info("localEnv", string).info("notifyEnv", string2));
                            return;
                        }
                    }
                    if (Objects.equals(Shared.this.topic, iMPushGroupSysMsgRequest.getTopic()) && Objects.equals(Shared.this.groupId, iMPushGroupSysMsgRequest.getGroupId())) {
                        Log.i(Shared.this.sourceName(), Trace.once().method("onSharedSourceChanged").info("topic", iMPushGroupSysMsgRequest.getTopic()).info("groupId", iMPushGroupSysMsgRequest.getGroupId()).info("seqId", iMPushGroupSysMsgRequest.getSeqId()));
                        notifyHandler.onNotify(iMPushGroupSysMsgRequest.getPrevSeqId(), iMPushGroupSysMsgRequest.getMsg(), iMPushGroupSysMsgRequest.getSeqId());
                    }
                }
            };
            HMR.getService(Channel.class).addNotificationHandler(this.sharedHandler);
            HMR.getService(Channel.class).subscribeGroupcast(this.getGroup(), null);
        }

        @Override
        public void stop() {
            Log.i(this.sourceName(), Trace.once().method("stop"));
            HMR.getService(Channel.class).removeNotificationHandler(this.sharedHandler);
            HMR.getService(Channel.class).unSubscribeGroupcast(this.getGroup(), null);
        }

        @Override
        public String getArea() {
            return this.area;
        }

        private String getGroup() {
            return String.format(Locale.US, "hummer:%d:%s:%d", HMRContext.getAppId(), this.topic, this.groupId);
        }

        private String prefKey() {
            if (this.topic.isEmpty()) {
                return this.groupId + PrefKeySeqID;
            }
            return this.groupId + "_" + this.topic + PrefKeySeqID;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Shared shared = (Shared)object;
            if (this.groupId != shared.groupId) {
                return false;
            }
            if (this.topic != null ? !this.topic.equals(shared.topic) : shared.topic != null) {
                return false;
            }
            return this.area != null ? this.area.equals(shared.area) : shared.area == null;
        }

        public int hashCode() {
            int n = (int)(this.groupId ^ this.groupId >>> 32);
            n = 31 * n + (this.topic != null ? this.topic.hashCode() : 0);
            n = 31 * n + (this.area != null ? this.area.hashCode() : 0);
            return n;
        }
    }

    public static class Private
    implements Mode {
        private static final String StorageKeySeqIDPrefix = "local_sequence_id";
        private final String topic;
        private Channel.NotificationHandler changeHandler;
        private MQService.FetchStrategy strategy;
        private long pullingPeriod;
        private Long checkTermId;
        private Integer checkIntegritySeqId;
        private long checkLastSeqId;
        private boolean isCheckIntegrity = false;

        public Private(String string) {
            this(string, null);
        }

        public Private(String string, MQService.FetchStrategy fetchStrategy) {
            this(string, fetchStrategy, 900000L);
        }

        public Private(String string, MQService.FetchStrategy fetchStrategy, long l) {
            this.topic = string == null ? "" : string;
            this.strategy = fetchStrategy;
            this.pullingPeriod = l < 1L ? 900000L : l;
        }

        @Override
        public void setCheckIntegrity(boolean bl) {
            this.isCheckIntegrity = bl;
        }

        @Override
        public Long getCheckTermId() {
            return this.checkTermId;
        }

        @Override
        public Integer getCheckIntegritySeqId() {
            return this.checkIntegritySeqId;
        }

        @Override
        public boolean isCheckIntegrity() {
            return this.isCheckIntegrity;
        }

        @Override
        public void updateParam(Im.Msg msg) {
            this.checkTermId = msg.getTerm();
            this.checkIntegritySeqId = msg.getIntegrityCheckSeq();
            this.checkLastSeqId = msg.getSeqId();
        }

        @Override
        public MQService.FetchStrategy getStrategy() {
            return this.strategy;
        }

        @Override
        public long getPullingPeriod() {
            return this.pullingPeriod;
        }

        @Override
        public String sourceName() {
            return "PrivateSource(" + this.topic + ")";
        }

        @Override
        public String topicName() {
            return this.topic;
        }

        @Override
        public void loadSeqId(MQService.FetchStrategy fetchStrategy, RichCompletionArg<Long> richCompletionArg) {
            Long l = null;
            if (fetchStrategy == MQService.FetchStrategy.Continuously) {
                l = PrefStorage.storage().execute(new PrefStorage.Query<Long>(){

                    @Override
                    public Long run(SharedPreferences sharedPreferences) {
                        if (sharedPreferences == null) {
                            return null;
                        }
                        long l = sharedPreferences.getLong(Private.this.prefKey(), -1L);
                        if (l == -1L) {
                            return null;
                        }
                        return l;
                    }
                });
            } else if (fetchStrategy == MQService.FetchStrategy.ReloadHistories) {
                l = 0L;
            }
            Log.i(this.sourceName(), Trace.once().method("loadSeqId").info("seqId", l));
            if (l == null) {
                if (fetchStrategy == MQService.FetchStrategy.IgnoreBefore) {
                    this.fetchMaxSeqId(3, this.topic, richCompletionArg);
                } else {
                    this.fetchSeqId(3, this.topic, richCompletionArg);
                }
            } else {
                CompletionUtils.dispatchSuccess(richCompletionArg, l);
            }
        }

        @Override
        public void storeSeqId(final long l) {
            PrefStorage.storage().execute(new PrefStorage.Edit(){

                @Override
                public void run(SharedPreferences.Editor editor) {
                    editor.putLong(Private.this.prefKey(), l);
                }
            });
            HMR.getService(Channel.class).run(new RPCReportPrivateSeqId(this.topic, l, null));
        }

        @Override
        public Channel.RPC createPullingRequest(long l, boolean bl, RichCompletionArg<RPCPullingResponse> richCompletionArg) {
            return new RPCPullPrivateMessages(this.topic, bl, l, 200, null, richCompletionArg);
        }

        @Override
        public void checkIntegrityRequest(Im.Msg msg) {
            HMR.getService(Channel.class).run(new RPCCheckMsgIntegrity(this.topic, this.checkLastSeqId, msg.getSeqId(), 0, null));
        }

        @Override
        public void start(final Mode.NotifyHandler notifyHandler) {
            Log.i(this.sourceName(), Trace.once().method("start"));
            this.changeHandler = new Channel.NotificationHandler(){

                @Override
                public void onNotify(String string, String string2, final byte[] byArray) {
                    String string3 = "service_api_gateway/cim.proto.PushService.IMPushMsg";
                    String string4 = string + '/' + string2;
                    if (!string3.equals(string4)) {
                        return;
                    }
                    HMRContext.work.async("Source::onNotify", new Runnable(){

                        @Override
                        public void run() {
                            this.handleNotify(byArray);
                        }
                    });
                }

                public String toString() {
                    return Private.this.sourceName();
                }

                private void handleNotify(byte[] byArray) {
                    try {
                        Push.IMPushMsgRequest iMPushMsgRequest = (Push.IMPushMsgRequest)((Push.IMPushMsgRequest.Builder)Push.IMPushMsgRequest.newBuilder().mergeFrom(byArray)).build();
                        if (iMPushMsgRequest.getEnvName() != null && !iMPushMsgRequest.getEnvName().isEmpty()) {
                            if (HMRContext.region == null) {
                                Log.w(Private.this.sourceName(), Trace.once().method("onNotify").msg("localEnv is null"));
                                return;
                            }
                            HMRContext.Region region = HMRContext.region;
                            String string = String.format(Locale.US, "%s_%s_%s", region.type, region.name, region.area);
                            String string2 = String.format(Locale.US, "%s_%s_%s", iMPushMsgRequest.getEnvType(), iMPushMsgRequest.getEnvName(), HMRContext.Region.getArea(iMPushMsgRequest.getRegion()));
                            if (!Objects.equals(string2, string)) {
                                Log.i(Private.this.sourceName(), Trace.once().method("onNotify").msg("Ignored notify of different env").info("localEnv", string).info("remoteEnv", string2));
                                return;
                            }
                        }
                        if (Objects.equals(Private.this.topic, iMPushMsgRequest.getTopic())) {
                            Log.i(Private.this.sourceName(), Trace.once().method("onPrivateSourceChanged").info("topic", iMPushMsgRequest.getTopic()).info("seqId", iMPushMsgRequest.getSeqId()));
                            notifyHandler.onNotify(0L, null, iMPushMsgRequest.getSeqId());
                        }
                    }
                    catch (Throwable throwable) {
                        Log.e(Private.this.sourceName(), Trace.once("Failed parsing IMPushMsgRequest").info("Exception", throwable));
                    }
                }
            };
            HMR.getService(Channel.class).addNotificationHandler(this.changeHandler);
        }

        @Override
        public void stop() {
            Log.i(this.sourceName(), Trace.once().method("stop"));
            HMR.getService(Channel.class).removeNotificationHandler(this.changeHandler);
        }

        @Override
        public String getArea() {
            return null;
        }

        private void fetchSeqId(final int n, final String string, final RichCompletionArg<Long> richCompletionArg) {
            Log.i(this.sourceName(), Trace.once().method("fetchSeqId"));
            if (n <= 0) {
                CompletionUtils.dispatchFailure(richCompletionArg, new Error(1005, "Failed fetching seqId: " + string));
                return;
            }
            HMR.getService(Channel.class).run(new RPCFetchPrivateSeqId(string, new RichCompletionArg<Long>("Source::RPCFetchPrivateSeqId:" + string).onSuccess(new OnSuccessArg<Long>(){

                @Override
                public void onSuccess(Long l) {
                    CompletionUtils.dispatchSuccess(richCompletionArg, l);
                }
            }).onFailure(new OnFailure(){

                @Override
                public void onFailure(Error error) {
                    if (error != null && error.code != 1005) {
                        CompletionUtils.dispatchFailure(richCompletionArg, error);
                    } else {
                        HMRContext.work.asyncAfter("Source::repeatFetch", 3000, new Runnable(){

                            @Override
                            public void run() {
                                Private.this.fetchSeqId(n - 1, string, richCompletionArg);
                            }
                        });
                    }
                }
            })));
        }

        private void fetchMaxSeqId(final int n, final String string, final RichCompletionArg<Long> richCompletionArg) {
            Log.i(this.sourceName(), Trace.once().method("fetchMaxSeqId"));
            if (n <= 0) {
                CompletionUtils.dispatchFailure(richCompletionArg, new Error(1005, "Failed fetching seqId: " + string));
                return;
            }
            HMR.getService(Channel.class).run(new RPCFetchPrivateMaxSeqId(string, new RichCompletionArg<Long>("Source::RPCFetchPrivateMaxSeqId:" + string).onSuccess(new OnSuccessArg<Long>(){

                @Override
                public void onSuccess(Long l) {
                    CompletionUtils.dispatchSuccess(richCompletionArg, l);
                }
            }).onFailure(new OnFailure(){

                @Override
                public void onFailure(Error error) {
                    if (error != null && error.code != 1005) {
                        CompletionUtils.dispatchFailure(richCompletionArg, error);
                    } else {
                        HMRContext.work.asyncAfter("Source::repeatFetch", 3000, new Runnable(){

                            @Override
                            public void run() {
                                Private.this.fetchMaxSeqId(n - 1, string, richCompletionArg);
                            }
                        });
                    }
                }
            })));
        }

        private String prefKey() {
            String string = StorageKeySeqIDPrefix;
            if (!this.topic.isEmpty()) {
                string = string + "_" + this.topic;
            }
            return string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Private private_ = (Private)object;
            return this.topic.equals(private_.topic);
        }

        public int hashCode() {
            return this.topic.hashCode();
        }
    }

    public static interface Mode {
        public String sourceName();

        public String topicName();

        public MQService.FetchStrategy getStrategy();

        public long getPullingPeriod();

        public void loadSeqId(MQService.FetchStrategy var1, RichCompletionArg<Long> var2);

        public void storeSeqId(long var1);

        public Channel.RPC createPullingRequest(long var1, boolean var3, RichCompletionArg<RPCPullingResponse> var4);

        public void checkIntegrityRequest(Im.Msg var1);

        public void start(NotifyHandler var1);

        public void stop();

        public String getArea();

        public Long getCheckTermId();

        public Integer getCheckIntegritySeqId();

        public boolean isCheckIntegrity();

        public void updateParam(Im.Msg var1);

        public void setCheckIntegrity(boolean var1);

        public static interface NotifyHandler {
            public void onNotify(long var1, Im.Msg var3, long var4);
        }
    }
}

