/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.User;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;

public class RPCFetchPrivateSeqId
extends IMRPC<User.GetMaxAcquiredSeqIDRequest, User.GetMaxAcquiredSeqIDRequest.Builder, User.GetMaxAcquiredSeqIDResponse> {
    public static final String TAG = "RPCFetchPrivateSeqId";
    private final String topic;
    private final RichCompletionArg<Long> completion;
    private final Trace.Flow flow = new Trace.Flow();

    public RPCFetchPrivateSeqId(String string, RichCompletionArg<Long> richCompletionArg) {
        this.topic = string;
        this.completion = richCompletionArg;
    }

    @Override
    public long getLogId() {
        return this.flow.logId;
    }

    @Override
    public String getHummerFunction() {
        return "GetMaxAcquiredSeqID";
    }

    @Override
    public String describeHummerResponse(@NonNull User.GetMaxAcquiredSeqIDResponse getMaxAcquiredSeqIDResponse) {
        return new StringChain().acceptNullElements().add("srvCode", getMaxAcquiredSeqIDResponse.getCode()).add("srvDesc", getMaxAcquiredSeqIDResponse.getMsg()).add("seqId", getMaxAcquiredSeqIDResponse.getSeqId()).toString();
    }

    @Override
    public void buildHummerRequest(@NonNull User.GetMaxAcquiredSeqIDRequest.Builder builder) {
        ((User.GetMaxAcquiredSeqIDRequest)builder.setTopic(this.topic).build()).toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull User.GetMaxAcquiredSeqIDResponse getMaxAcquiredSeqIDResponse) {
        CompletionUtils.dispatchSuccess(this.completion, getMaxAcquiredSeqIDResponse.getSeqId());
    }

    @Override
    public void handleHummerError(@Nullable User.GetMaxAcquiredSeqIDResponse getMaxAcquiredSeqIDResponse, @NonNull Error error) {
        if (error.code == 2004) {
            CompletionUtils.dispatchSuccess(this.completion, 0L);
        } else {
            CompletionUtils.dispatchFailure(this.completion, error);
        }
    }
}

