/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.mq;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.proto.Pull;
import com.hummer.im._internals.shared.StringChain;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;

public class RPCCheckMsgIntegrity
extends IMRPC<Pull.CheckMsgIntegrityRequest, Pull.CheckMsgIntegrityRequest.Builder, Pull.CheckMsgIntegrityResponse> {
    public static final String TAG = "RPCCheckMsgIntegrity";
    private final String topic;
    private final long startSeq;
    private final long endSeq;
    private final int queueId;
    private final RichCompletion completion;
    private final Trace.Flow flow = new Trace.Flow();

    public RPCCheckMsgIntegrity(String string, long l, long l2, int n, RichCompletion richCompletion) {
        this.topic = string;
        this.startSeq = l;
        this.endSeq = l2;
        this.queueId = n;
        this.completion = richCompletion;
    }

    @Override
    public long getLogId() {
        return this.flow.logId;
    }

    @Override
    public String getHummerFunction() {
        return "CheckMsgIntegrity";
    }

    @Override
    public String describeHummerResponse(@NonNull Pull.CheckMsgIntegrityResponse checkMsgIntegrityResponse) {
        return new StringChain().acceptNullElements().add("srvCode", checkMsgIntegrityResponse.getCode()).add("srvDesc", checkMsgIntegrityResponse.getMsg()).toString();
    }

    @Override
    public void buildHummerRequest(@NonNull Pull.CheckMsgIntegrityRequest.Builder builder) {
        ((Pull.CheckMsgIntegrityRequest)builder.setTopic(this.topic).setStartSeq(this.startSeq).setEndSeq(this.endSeq).setQueueId(this.queueId).build()).toByteArray();
    }

    @Override
    public void handleHummerSuccess(@NonNull Pull.CheckMsgIntegrityResponse checkMsgIntegrityResponse) {
        CompletionUtils.dispatchSuccess(this.completion);
    }

    @Override
    public void handleHummerError(@Nullable Pull.CheckMsgIntegrityResponse checkMsgIntegrityResponse, @NonNull Error error) {
        CompletionUtils.dispatchFailure(this.completion, error);
    }
}

