/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.mq;

import android.support.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.Objects;
import com.hummer.im._internals.PrefStorage;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.mq.RPCReportUserRegion;
import com.hummer.im._internals.mq.Source;
import com.hummer.im._internals.proto.Im;
import com.hummer.im._internals.services.mq.StatisticsReporter;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.OnFailure;
import com.hummer.im.model.completion.OnSuccess;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.service.Channel;
import com.hummer.im.service.MQService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class MQServiceImpl
implements ServiceProvider.Service,
MQService,
MQService.MessagesDispatcher {
    private static final String TAG = "MQService";
    private final Set<MQService.Source> sources = new HashSet<MQService.Source>();
    private String runningToken;
    private boolean isConnected;
    private Channel.StateChangedListener channelStateListener;
    private MQService.FetchStrategy mFetchStrategy = MQService.FetchStrategy.Continuously;
    private final List<MQService.MsgParser> mMsgParsers = new ArrayList<MQService.MsgParser>();

    @Override
    public Class[] staticDependencies() {
        return new Class[]{Channel.class};
    }

    @Override
    public Class[] plantingDynamicDependencies() {
        return null;
    }

    @Override
    public void initService() {
    }

    @Override
    public Class[] inherentDynamicDependencies() {
        return new Class[]{UserService.class, PrefStorage.class};
    }

    @Override
    public void openService(@NonNull RichCompletion richCompletion) {
        if (this.runningToken != null) {
            Log.w(TAG, Trace.once().method("openService").msg("\u5728\u670d\u52a1\u5df2\u8fd0\u884c\u72b6\u6001\u4e0b\u8c03\u7528\u4e86openService\u65b9\u6cd5"));
            return;
        }
        this.runningToken = UUID.randomUUID().toString();
        if (HMR.getMe().isAnonymous()) {
            CompletionUtils.dispatchSuccess(richCompletion);
            return;
        }
        this.prepareChannel();
        if (HMRContext.region != null) {
            HMRContext.work.async("", new Runnable(){

                @Override
                public void run() {
                    MQServiceImpl.this.reportUserRegion();
                }
            });
        }
        for (MQService.Source source : this.sources) {
            source.start(this);
        }
        this.scheduleTimerPulse();
        CompletionUtils.dispatchSuccess(richCompletion);
    }

    private void reportUserRegion() {
        Log.i(TAG, Trace.once().method("reportUserRegion").msg("start"));
        HMR.getService(Channel.class).run(new RPCReportUserRegion(new RichCompletion("").onSuccess(new OnSuccess(){

            @Override
            public void onSuccess() {
                Log.i(MQServiceImpl.TAG, Trace.once().method("reportUserRegion").msg("success").info("user", HMR.getMe()).info("region", HMRContext.region == null ? "null" : HMRContext.region.area));
            }
        }).onFailure(new OnFailure(){

            @Override
            public void onFailure(Error error) {
                Log.e(MQServiceImpl.TAG, Trace.once().method("reportUserRegion").msg("failed").info("user", HMR.getMe()).info("region", HMRContext.region == null ? "null" : HMRContext.region.area).info("error", error));
                HMRContext.work.asyncAfter("", 300000, new Runnable(){

                    @Override
                    public void run() {
                        MQServiceImpl.this.reportUserRegion();
                    }
                });
            }
        })));
    }

    @Override
    public void closeService() {
        if (this.runningToken == null) {
            Log.w(TAG, Trace.once().method("openService").msg("\u5728\u670d\u52a1\u5df2\u5173\u95ed\u72b6\u6001\u4e0b\u8c03\u7528\u4e86closeService\u65b9\u6cd5"));
            return;
        }
        if (HMR.getMe().isAnonymous()) {
            this.runningToken = null;
            return;
        }
        for (MQService.Source source : this.sources) {
            source.stop();
        }
        this.teardownChannel();
        this.runningToken = null;
    }

    @Override
    public MQService.FetchStrategy getFetchStrategy() {
        return this.mFetchStrategy;
    }

    @Override
    public void setFetchStrategy(MQService.FetchStrategy fetchStrategy) {
        this.mFetchStrategy = fetchStrategy;
    }

    @Override
    public void addSource(final MQService.Source source) {
        HMRContext.work.async("MQServiceImpl::addSource", new Runnable(){

            @Override
            public void run() {
                Log.i(MQServiceImpl.TAG, Trace.once().method("addSource").info("source", source));
                if (MQServiceImpl.this.sources.contains(source)) {
                    Log.i(MQServiceImpl.TAG, Trace.once().method("addSource").info("Duplicate source", source));
                    return;
                }
                MQServiceImpl.this.sources.add(source);
                StatisticsReporter.Frequencies.put(StatisticsReporter.Codes.NotResetIsDraining.intValue(), MQServiceImpl.this.sources.size());
                if (MQServiceImpl.this.isRunning()) {
                    source.start(MQServiceImpl.this);
                }
            }
        });
    }

    @Override
    public void removeSource(final MQService.Source source) {
        HMRContext.work.async("MQServiceImpl::removeSource", new Runnable(){

            @Override
            public void run() {
                Log.i(MQServiceImpl.TAG, Trace.once().method("removeSource").info("source", source));
                MQService.Source source2 = MQServiceImpl.this.getSource(source);
                if (MQServiceImpl.this.isRunning()) {
                    source2.stop();
                }
                MQServiceImpl.this.sources.remove(source2);
            }
        });
    }

    @Override
    public void pullManually() {
        HMRContext.work.async("MQServiceImpl::pullManually", new Runnable(){

            @Override
            public void run() {
                Log.i(MQServiceImpl.TAG, Trace.once().method("pullManually"));
                MQServiceImpl.this.notifyPullManually();
            }
        });
    }

    @Override
    public void dispatch(List<Im.Msg> list, Source source) {
        if (!this.sourceExist(source)) {
            Log.i(TAG, Trace.once().method("interrupt dispatch for source disappear"));
            return;
        }
        for (Im.Msg msg : list) {
            this.parseMsg(msg, source);
        }
    }

    private boolean sourceExist(MQService.Source source) {
        for (MQService.Source source2 : this.sources) {
            if (source2 != source) continue;
            return true;
        }
        return false;
    }

    private MQService.Source getSource(MQService.Source source) {
        for (MQService.Source source2 : this.sources) {
            if (!source2.equals(source)) continue;
            return source2;
        }
        return source;
    }

    private void prepareChannel() {
        if (this.channelStateListener != null) {
            Log.e("MQServiceImpl", Trace.once().method("prepareChannel").info("channelStateListener exception", null));
            return;
        }
        this.isConnected = true;
        this.channelStateListener = new Channel.StateChangedListener(){

            @Override
            public void onPreChannelConnected() {
            }

            @Override
            public void onChannelConnected() {
                HMRContext.work.async("MQServiceImpl::onChannelConnected", new Runnable(){

                    @Override
                    public void run() {
                        Log.w(MQServiceImpl.TAG, Trace.once().method("onChannelConnected"));
                        MQServiceImpl.this.isConnected = true;
                        MQServiceImpl.this.notifyNetworkReconnected();
                    }
                });
            }

            @Override
            public void onChannelDisconnected() {
                HMRContext.work.async("MQServiceImpl::onChannelDisconnected", new Runnable(){

                    @Override
                    public void run() {
                        Log.w(MQServiceImpl.TAG, Trace.once().method("onChannelDisconnected"));
                        MQServiceImpl.this.isConnected = false;
                    }
                });
            }
        };
        HMR.getService(Channel.class).addStateListener(this.channelStateListener);
    }

    private void teardownChannel() {
        HMR.getService(Channel.class).removeStateListener(this.channelStateListener);
        this.channelStateListener = null;
        this.isConnected = false;
    }

    private void scheduleTimerPulse() {
        final String string = this.runningToken;
        int n = 10000;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!Objects.equals(string, MQServiceImpl.this.runningToken)) {
                    return;
                }
                if (!MQServiceImpl.this.isConnected) {
                    return;
                }
                for (MQService.Source source : MQServiceImpl.this.sources) {
                    source.onTimerPulse(MQServiceImpl.this);
                }
                HMRContext.work.asyncAfter("MQServiceImpl::timer:inspector", 10000, this);
            }
        };
        HMRContext.work.asyncAfter("MQServiceImpl::scheduleTimerPulse", 10000, runnable);
    }

    private boolean isRunning() {
        return this.runningToken != null;
    }

    private void notifyNetworkReconnected() {
        for (MQService.Source source : this.sources) {
            source.onNetworkReconnected(this);
        }
    }

    private void notifyPullManually() {
        for (MQService.Source source : this.sources) {
            source.onManualPullingRequest(this);
        }
    }

    @Override
    public void registerMsgParser(MQService.MsgParser msgParser) {
        this.mMsgParsers.add(msgParser);
    }

    private void parseMsg(Im.Msg msg, Source source) {
        for (MQService.MsgParser msgParser : this.mMsgParsers) {
            try {
                msgParser.parse(msg, source);
            }
            catch (Exception exception) {
                Log.e(TAG, Trace.once().msg("parseMsg").msg("Parsing failed").info("msg", msg).info("exception", exception));
            }
        }
    }
}

