/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals.channel;

import android.os.Handler;
import android.support.annotation.NonNull;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.service.Channel;
import com.hummer.im.service.ChannelStateService;
import com.yy.platform.baseservice.IChannelListener;
import com.yy.platform.baseservice.YYServiceCore;
import java.util.HashSet;

public final class ChannelStateServiceImp
implements ServiceProvider.Service,
ChannelStateService,
IChannelListener.IChannelStatusNotify {
    private static final String TAG = "ChannelStateService";
    private ChannelStateService.ChannelState mState = ChannelStateService.ChannelState.Unavailable;
    private final HashSet<ChannelStateService.ChannelStateListener> mListeners = new HashSet();

    @Override
    public Class[] staticDependencies() {
        return new Class[]{Channel.class};
    }

    @Override
    public Class[] inherentDynamicDependencies() {
        return new Class[]{Channel.class};
    }

    @Override
    public Class[] plantingDynamicDependencies() {
        return null;
    }

    @Override
    public void initService() {
        if (YYServiceCore.getInstance() != null) {
            YYServiceCore.getInstance().registChannelStatusListener((IChannelListener.IChannelStatusNotify)this, new Handler());
            this.onStatus(YYServiceCore.getInstance().getChannelStatus());
        }
    }

    @Override
    public void openService(@NonNull RichCompletion richCompletion) {
        CompletionUtils.dispatchSuccess(richCompletion);
    }

    @Override
    public void closeService() {
    }

    @Override
    public ChannelStateService.ChannelState getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChannelStateListener(@NonNull ChannelStateService.ChannelStateListener channelStateListener) {
        HashSet<ChannelStateService.ChannelStateListener> hashSet = this.mListeners;
        synchronized (hashSet) {
            this.mListeners.add(channelStateListener);
            Log.i(TAG, Trace.once().method("addChannelStateListener").info("name", channelStateListener.getClass().getSimpleName()).info("size", this.mListeners.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChannelStateListener(@NonNull ChannelStateService.ChannelStateListener channelStateListener) {
        HashSet<ChannelStateService.ChannelStateListener> hashSet = this.mListeners;
        synchronized (hashSet) {
            this.mListeners.remove(channelStateListener);
            Log.i(TAG, Trace.once().method("removeStateListener").info("name", channelStateListener.getClass().getSimpleName()).info("size", this.mListeners.size()));
        }
    }

    private void updateChannelState(ChannelStateService.ChannelState channelState) {
        if (channelState == this.mState) {
            return;
        }
        final ChannelStateService.ChannelState channelState2 = this.mState;
        this.mState = channelState;
        DispatchQueue.main.async("ChannelStateServiceImp::updateChannelState", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet hashSet = ChannelStateServiceImp.this.mListeners;
                synchronized (hashSet) {
                    Log.i(ChannelStateServiceImp.TAG, Trace.once().method("updateChannelState").info("fromState", (Object)channelState2).info("toState", (Object)ChannelStateServiceImp.this.mState).info("size", ChannelStateServiceImp.this.mListeners.size()));
                    HashSet hashSet2 = (HashSet)ChannelStateServiceImp.this.mListeners.clone();
                    for (ChannelStateService.ChannelStateListener channelStateListener : hashSet2) {
                        channelStateListener.onUpdateChannelState(channelState2, ChannelStateServiceImp.this.mState);
                    }
                }
            }
        });
    }

    public void onStatus(int n) {
        if (n == 6) {
            this.updateChannelState(ChannelStateService.ChannelState.Connected);
        } else if (n == 0 || n == 5 || n == 4 || n == 2) {
            this.updateChannelState(ChannelStateService.ChannelState.Disconnected);
        } else {
            this.updateChannelState(ChannelStateService.ChannelState.Connecting);
        }
    }
}

