/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im._internals;

import android.content.Context;
import android.os.Process;
import android.support.annotation.NonNull;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.ETRecorder;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class HMRContext {
    public static final DispatchQueue work = new DispatchQueue(new DispatchQueue.WorkerHandler("hmr_core"));
    public static final ETRecorder recorder = new ETRecorder(Integer.toString(Process.myPid()));
    public static WeakReference<Context> appContext;
    public static Long appId;
    public static Region region;
    public static String chatRoomRegion;

    public static Context getAppContext() {
        return (Context)appContext.get();
    }

    public static Long getAppId() {
        return appId;
    }

    public static final class Region {
        public static final String AREA_CN = "cn";
        private static final String AREA_AP_SOUTHEAST = "ap_southeast";
        private static final String AREA_US = "us";
        private static final String AREA_SA_EAST = "sa_east";
        private static final String AREA_AP_SOUTH = "ap_south";
        public final String area;
        public final String type;
        public final String name;
        private static Map<String, String> regionMap = new HashMap<String, String>();

        Region(String string, String string2, String string3) {
            this.type = string2;
            this.name = string3;
            this.area = string;
        }

        public String toString() {
            return String.format(Locale.US, "%s/%s/%s", this.area, this.type, this.name);
        }

        public static Region make(@NonNull String string) {
            String[] stringArray = string.split("/");
            String[] stringArray2 = new String[]{"china", "private", "share"};
            for (int i = 0; i < 3; ++i) {
                if (stringArray.length <= i || stringArray[i].isEmpty()) continue;
                stringArray2[i] = stringArray[i];
            }
            return new Region(stringArray2[0], stringArray2[1], stringArray2[2]);
        }

        public static String getArea(String string) {
            String string2 = regionMap.get(string);
            return string2 == null ? string : string2;
        }

        static {
            regionMap.put("china", AREA_CN);
            regionMap.put("indonesia", AREA_AP_SOUTHEAST);
            regionMap.put("america", AREA_US);
            regionMap.put("brazil", AREA_SA_EAST);
            regionMap.put("india", AREA_AP_SOUTH);
        }
    }
}

