/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.ServiceChannel;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.log.HummerLogger;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.trace.Trace;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.DispatchQueue;
import com.hummer.im._internals.shared.HiidoReporter;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.id.Identifiable;
import com.hummer.im.model.id.User;
import com.hummer.im.service.Channel;
import com.yy.spidercrab.SCLog;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;

public final class HMR {
    private static final Set<StateListener> mListeners = new HashSet<StateListener>();
    private static final Set<TokenInvalidListener> tokenInvalidListeners = new HashSet<TokenInvalidListener>();
    private static final String TAG = "Hummer";
    private static State state = State.Unavailable;
    private static User me;
    private static Set<String> tags;
    private static final Channel.TokenInvalidHandler TOKEN_INVALID_HANDLER;

    public static void init(final @NonNull Context context, final long l) {
        HMRContext.work.sync("HMR::init", new Runnable(){

            @Override
            public void run() {
                if (HMR.isInitialized()) {
                    Log.e("HMR", Trace.once().method("init").info("Hummer already been initialized!", ""));
                    return;
                }
                HMRContext.appId = l;
                HMRContext.appContext = new WeakReference<Context>(context.getApplicationContext());
                HMR.setupLogger(context);
                if (HMR.getService(Channel.class) == null) {
                    ServiceChannel serviceChannel = new ServiceChannel(new ServiceChannel.AutonomousMode(1));
                    ServiceProvider.register(Channel.class, serviceChannel);
                }
                ServiceProvider.loadServicesIfNeeded(context, "com.hummer.im");
                HMR.state = State.Closed;
            }
        });
    }

    private static void setupLogger(Context context) {
        if (Log.getLogger() == null) {
            if (HMR.isApkInDebug(context)) {
                SCLog.enableConsoleLogger((boolean)true);
            }
            SCLog.init((Context)context);
            Log.setLogger(new HummerLogger("HMR"));
        }
    }

    private static boolean isApkInDebug(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            return (applicationInfo.flags & 2) != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void open(final long l, final @NonNull String string, final @Nullable Set<String> set, final @NonNull String string2, @Nullable Completion completion) {
        HMR.performServiceAvailableCheck();
        final RichCompletion richCompletion = new RichCompletion(completion, "HMR.open");
        HMRContext.work.async("HMR::open", new Runnable(){

            @Override
            public void run() {
                if (HMR.getState() != State.Closed) {
                    Log.w(HMR.TAG, Trace.once().method("open").msg("\u7528\u6237\u4e0a\u4e0b\u6587\u91cd\u5165").info("currentUID", HMR.getMe()).info("requestUID", l));
                    CompletionUtils.dispatchFailure(richCompletion, new Error(1011, "Replicated HMR.open"));
                    return;
                }
                HMR.getService(Channel.class).addTokenInvalidHandler(TOKEN_INVALID_HANDLER);
                HMR.refreshToken(string2);
                HMR.initChannelBindResultHandler();
                Log.i(HMR.TAG, Trace.once().method("open").msg("open sdk").info("uid", l));
                HMR.setHummerState(State.Opening);
                me = new User(l);
                HMRContext.region = HMRContext.Region.make(string);
                tags = set;
                HMR.setReportRegion();
                ServiceProvider.openServices(richCompletion.beforeFailure(new Runnable(){

                    @Override
                    public void run() {
                        HMRContext.region = null;
                        me = null;
                        HMR.setHummerState(State.Closed);
                    }
                }).beforeSuccess(new Runnable(){

                    @Override
                    public void run() {
                        HMR.setHummerState(State.Opened);
                        if (tags != null) {
                            HMR.getService(UserService.class).setTags(tags, null);
                        }
                        Log.i(HMR.TAG, Trace.once().method("open").msg("finish"));
                    }
                }));
            }
        });
    }

    private static void setReportRegion() {
        if ("china".equals(HMRContext.region.area)) {
            HiidoReporter.setRegion(HiidoReporter.Region.China);
        } else {
            HiidoReporter.setRegion(HiidoReporter.Region.Overseas);
        }
    }

    public static <Service> Service getService(@NonNull Class<Service> clazz) {
        return ServiceProvider.get(clazz);
    }

    public static void close(@Nullable Completion completion) {
        HMR.performServiceAvailableCheck();
        final RichCompletion richCompletion = new RichCompletion(completion, "HMR.close");
        HMRContext.work.async("HMR::close", new Runnable(){

            @Override
            public void run() {
                if (HMR.getState() != State.Opened) {
                    Log.w(HMR.TAG, Trace.once().method("close").msg("Miss-match closing"));
                    CompletionUtils.dispatchFailure(richCompletion, new Error(1011, "Miss-match closing"));
                    return;
                }
                Log.i(HMR.TAG, Trace.once().method("close"));
                HMR.setHummerState(State.Closing);
                HMR.getService(Channel.class).removeTokenInvalidHandler(TOKEN_INVALID_HANDLER);
                ServiceProvider.closeServices();
                HMR.setHummerState(State.Closed);
                me = null;
                HMRContext.region = null;
                CompletionUtils.dispatchSuccess(richCompletion);
                Log.i(HMR.TAG, Trace.once().method("close").msg("finish"));
            }
        });
    }

    public static void refreshToken(@NonNull String string) {
        if (HMR.checkChannelServiceAvailable()) {
            return;
        }
        HMR.getService(Channel.class).refreshToken(string);
    }

    private static boolean checkChannelServiceAvailable() {
        if (HMR.getService(Channel.class) == null) {
            Log.i(TAG, Trace.once().msg("channel service not ready"));
            return true;
        }
        return false;
    }

    public static void registerChannel(Channel channel) {
        ServiceProvider.register(Channel.class, channel);
    }

    public static State getState() {
        return state;
    }

    public static void addStateListener(final @NonNull StateListener stateListener) {
        HMRContext.work.async("HMR::addStateListener", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = mListeners;
                synchronized (set) {
                    mListeners.add(stateListener);
                    Log.i(HMR.TAG, Trace.once().method("addStateListener").info("size", mListeners.size()));
                }
                HMR.setHummerState(null);
            }
        });
    }

    public static void removeStateListener(final @NonNull StateListener stateListener) {
        HMRContext.work.async("HMR::removeStateListener", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = mListeners;
                synchronized (set) {
                    mListeners.remove(stateListener);
                    Log.i(HMR.TAG, Trace.once().method("removeStateListener").info("size", mListeners.size()));
                }
            }
        });
    }

    public static void addTokenInvalidListener(final @NonNull TokenInvalidListener tokenInvalidListener) {
        HMRContext.work.async("", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = tokenInvalidListeners;
                synchronized (set) {
                    tokenInvalidListeners.add(tokenInvalidListener);
                    Log.i(HMR.TAG, Trace.once().method("addTokenInvalidListener").info("size", tokenInvalidListeners.size()));
                }
            }
        });
    }

    public static void removeTokenInvalidListener(final @NonNull TokenInvalidListener tokenInvalidListener) {
        HMRContext.work.async("", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = tokenInvalidListeners;
                synchronized (set) {
                    tokenInvalidListeners.remove(tokenInvalidListener);
                    Log.i(HMR.TAG, Trace.once().method("removeTokenInvalidListener").info("size", tokenInvalidListeners.size()));
                }
            }
        });
    }

    private static void initChannelBindResultHandler() {
        HMR.getService(Channel.class).setChannelBindResultHandler(new Channel.ChannelBindResultHandler(){

            @Override
            public void onChannelBindResult(Error error) {
                Log.e(HMR.TAG, Trace.once().msg("channel bind failed: " + error));
                HMR.close(new Completion(){

                    @Override
                    public void onSuccess() {
                    }

                    @Override
                    public void onFailed(Error error) {
                        HMR.setHummerState(State.Closed);
                    }
                });
            }
        });
    }

    private static void setHummerState(@Nullable State state) {
        State state2 = HMR.state;
        if (state != null) {
            HMR.state = state;
        }
        HMR.notifyUpdateHummerState(state2, HMR.state);
    }

    private static void notifyUpdateHummerState(final State state, final State state2) {
        DispatchQueue.main.sync("HMR::notifyUpdateHummerState", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = mListeners;
                synchronized (set) {
                    for (StateListener stateListener : mListeners) {
                        stateListener.onUpdateHummerState(state, state2);
                    }
                }
            }
        });
    }

    private static void notifyTokenInvalid(final long l, final int n) {
        if (HMR.getMe() == null || HMR.getMe().getId() != l) {
            Log.i(TAG, Trace.once().method("notifyTokenInvalid").msg("user not login or notify uid is not current user").info("uid", HMR.getMe()).info("notifyUid", l));
            return;
        }
        DispatchQueue.main.sync("", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i(HMR.TAG, Trace.once().method("notifyTokenInvalid").info("uid", l).info("code", n));
                if (n == 1) {
                    Set set = tokenInvalidListeners;
                    synchronized (set) {
                        for (TokenInvalidListener tokenInvalidListener : tokenInvalidListeners) {
                            tokenInvalidListener.onHummerTokenInvalid(TokenInvalidCode.EXPIRED, "token\u5df2\u8fc7\u671f");
                        }
                    }
                }
            }
        });
    }

    public static String getVersion() {
        return "2.6.109";
    }

    public static User getMe() {
        return me;
    }

    public static Set<String> getTags() {
        return tags == null ? new HashSet() : tags;
    }

    public static boolean isMe(Identifiable identifiable) {
        return Identifiable.equals(me, identifiable);
    }

    private HMR() {
    }

    private static void performServiceAvailableCheck() {
        String string = "Hummer.init has to be called before acquiring it's services.";
        if (!HMR.isInitialized()) {
            Log.e("HMR", string);
        }
    }

    private static boolean isInitialized() {
        return HMRContext.appId != null || state != State.Unavailable;
    }

    static {
        TOKEN_INVALID_HANDLER = new Channel.TokenInvalidHandler(){

            @Override
            public void onTokenInvalid(long l, int n) {
                HMR.notifyTokenInvalid(l, n);
            }
        };
    }

    public static interface CompletionArg<Argument> {
        public void onSuccess(Argument var1);

        public void onFailed(Error var1);
    }

    public static interface Completion {
        public void onSuccess();

        public void onFailed(Error var1);
    }

    public static interface TokenInvalidListener {
        public void onHummerTokenInvalid(TokenInvalidCode var1, String var2);
    }

    public static interface StateListener {
        public void onUpdateHummerState(State var1, State var2);
    }

    public static enum TokenInvalidCode {
        EXPIRED(1);

        private int code;

        private TokenInvalidCode(int n2) {
            this.code = n2;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum State {
        Unavailable,
        Opening,
        Opened,
        Closing,
        Closed;

    }
}

