/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.user;

import com.hummer.im.model.id.User;
import java.util.HashMap;
import java.util.Map;

public class UserOnlineStatus {
    private User user;
    private OnlineStatus status;

    public UserOnlineStatus(User user, OnlineStatus status) {
        this.user = user;
        this.status = status;
    }

    public User getUser() {
        return this.user;
    }

    public OnlineStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserOnlineStatus that = (UserOnlineStatus)o;
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        int result = this.user != null ? this.user.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "UserOnlineStatus{user=" + this.user + ", status=" + (Object)((Object)this.status) + '}';
    }

    public static enum OnlineStatus {
        UNDEFINED(-1),
        OFFLINE(0),
        ONLINE(1),
        DISCONNECTED(2);

        private int status;
        private static Map<Integer, OnlineStatus> statusMap;

        private OnlineStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public static OnlineStatus getOnlineStatus(int status) {
            OnlineStatus onlineStatus = statusMap.get(status);
            return onlineStatus == null ? UNDEFINED : onlineStatus;
        }

        static {
            statusMap = new HashMap<Integer, OnlineStatus>();
            statusMap.put(UNDEFINED.getStatus(), UNDEFINED);
            statusMap.put(OFFLINE.getStatus(), OFFLINE);
            statusMap.put(ONLINE.getStatus(), ONLINE);
            statusMap.put(DISCONNECTED.getStatus(), DISCONNECTED);
        }
    }
}

