/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat.store;

import android.text.TextUtils;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageStoreStrategy {
    private boolean isRemoteHistoryMessage = false;
    private boolean isLocalHistoryMessage = true;
    private boolean isLastMessage = true;
    private boolean isUnreadCount = true;
    private static final String FIELD_IS_REMOTE_HISTORY_MESSAGE = "isRemoteHistoryMessage";
    private static final String FIELD_IS_LOCAL_HISTORY_MESSAGE = "isLocalHistoryMessage";
    private static final String FIELD_IS_LAST_MESSAGE = "isLastMessage";
    private static final String FIELD_IS_UNREAD_COUNT = "isUnreadCount";
    private static final String TAG = "MessageStoreStrategy";

    public MessageStoreStrategy() {
    }

    public MessageStoreStrategy(boolean isRemoteHistoryMessage, boolean isLocalHistoryMessage, boolean isLastMessage, boolean isUnreadCount) {
        this.isRemoteHistoryMessage = isRemoteHistoryMessage;
        this.isLocalHistoryMessage = isLocalHistoryMessage;
        this.isLastMessage = isLastMessage;
        this.isUnreadCount = isUnreadCount;
    }

    public boolean isRemoteHistoryMessage() {
        return this.isRemoteHistoryMessage;
    }

    public MessageStoreStrategy setRemoteHistoryMessage(boolean remoteHistoryMessage) {
        this.isRemoteHistoryMessage = remoteHistoryMessage;
        return this;
    }

    public boolean isLocalHistoryMessage() {
        return this.isLocalHistoryMessage;
    }

    public MessageStoreStrategy setLocalHistoryMessage(boolean localHistoryMessage) {
        this.isLocalHistoryMessage = localHistoryMessage;
        return this;
    }

    public boolean isLastMessage() {
        return this.isLastMessage;
    }

    public MessageStoreStrategy setLastMessage(boolean lastMessage) {
        this.isLastMessage = lastMessage;
        return this;
    }

    public boolean isUnreadCount() {
        return this.isUnreadCount;
    }

    public MessageStoreStrategy setUnreadCount(boolean unreadCount) {
        this.isUnreadCount = unreadCount;
        return this;
    }

    public static String makeString(MessageStoreStrategy storeStrategy) {
        if (storeStrategy == null) {
            return "";
        }
        JSONObject json = new JSONObject();
        try {
            json.put(FIELD_IS_REMOTE_HISTORY_MESSAGE, storeStrategy.isRemoteHistoryMessage());
            json.put(FIELD_IS_LOCAL_HISTORY_MESSAGE, storeStrategy.isLocalHistoryMessage());
            json.put(FIELD_IS_LAST_MESSAGE, storeStrategy.isLastMessage());
            json.put(FIELD_IS_UNREAD_COUNT, storeStrategy.isUnreadCount());
            return json.toString();
        }
        catch (JSONException e) {
            Log.e(TAG, Trace.method("makeString").info("store strategy to json error", e.getMessage()));
            return "";
        }
    }

    public static MessageStoreStrategy makeContent(String jsonStr) {
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        try {
            JSONObject json = new JSONObject(jsonStr);
            return new MessageStoreStrategy(json.getBoolean(FIELD_IS_REMOTE_HISTORY_MESSAGE), json.getBoolean(FIELD_IS_LOCAL_HISTORY_MESSAGE), json.getBoolean(FIELD_IS_LAST_MESSAGE), json.getBoolean(FIELD_IS_UNREAD_COUNT));
        }
        catch (JSONException e) {
            Log.e(TAG, Trace.method("makeContent").info("json to store strategy error", e.getMessage()));
            return null;
        }
    }

    public String toString() {
        return "MessageStoreStrategy{isRemoteHistoryMessage=" + this.isRemoteHistoryMessage + ", isLocalHistoryMessage=" + this.isLocalHistoryMessage + ", isLastMessage=" + this.isLastMessage + ", isUnreadCount=" + this.isUnreadCount + '}';
    }
}

