/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat.contents;

import android.media.MediaMetadataRetriever;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im._internals.utility.FileUtils;
import com.hummer.im.model.chat.Content;
import com.hummer.im.model.chat.contents.Image;
import java.io.File;
import java.util.Locale;
import org.json.JSONObject;

public class Video
extends Content {
    private static final String TAG = "Video";
    public static final int TYPE = 4;
    private final String videoUrl;
    private final long videoSize;
    private final int videoDuration;
    private final int videoWidth;
    private final int videoHeight;
    private final String coverUrl;
    private String coverThumbUrl;
    private final int coverWidth;
    private final int coverHeight;

    private Video(String videoUrl, long videoSize, int videoWidth, int videoHeight, int videoDuration, String coverUrl, int coverWidth, int coverHeight) {
        this.videoUrl = videoUrl;
        this.videoSize = videoSize;
        this.videoDuration = videoDuration;
        this.videoWidth = videoWidth;
        this.videoHeight = videoHeight;
        this.coverWidth = coverWidth;
        this.coverHeight = coverHeight;
        this.coverUrl = coverUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Video create(@NonNull String videoPath, long videoSize, int videoWidth, int videoHeight, int videoDuration, @NonNull String coverPath, int coverWidth, int coverHeight) {
        boolean videoFlag;
        Image coverImage;
        Log.i(TAG, Trace.method("create").info("video", videoPath).info("videoSize", videoSize).info("videoDuration", videoDuration).info("videoWidth", videoWidth).info("videoHeight", videoHeight).info("coverPath", coverPath).info("coverWidth", coverWidth).info("coverHeight", coverHeight));
        if (!TextUtils.isEmpty((CharSequence)coverPath) && (coverImage = Image.create(coverPath, coverWidth, coverHeight)) != null) {
            coverWidth = coverImage.getWidth();
            coverHeight = coverImage.getHeight();
        }
        if (FileUtils.isWebUrl(videoPath)) {
            Log.w(TAG, Trace.method("create").msg("Create url Video"));
            return new Video(videoPath, videoSize, videoWidth, videoHeight, videoDuration, coverPath, coverWidth, coverHeight);
        }
        File videoFile = new File(videoPath);
        boolean bl = videoFlag = videoFile.exists() && !videoFile.isDirectory();
        if (!videoFlag) {
            Log.w(TAG, Trace.method("create").msg("File not exists"));
            return new Video(videoPath, videoSize, videoWidth, videoHeight, videoDuration, coverPath, coverWidth, coverHeight);
        }
        if (videoFile.length() <= 0L) {
            Log.w(TAG, Trace.method("create").msg("File size is zero"));
            return null;
        }
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        String durationString = null;
        String videoWidthStr = null;
        String videoHeightStr = null;
        try {
            retriever.setDataSource(videoPath);
            durationString = retriever.extractMetadata(9);
            videoWidthStr = retriever.extractMetadata(18);
            videoHeightStr = retriever.extractMetadata(19);
        }
        catch (RuntimeException e) {
            Log.w(TAG, Trace.method("create").msg(String.format(Locale.US, "Video path: %s, error: %s", videoPath, e.getMessage())));
        }
        finally {
            retriever.release();
        }
        if (videoWidth < 1 || videoHeight < 1) {
            videoWidth = TextUtils.isEmpty((CharSequence)videoWidthStr) ? 0 : Integer.parseInt(videoWidthStr);
            int n = videoHeight = TextUtils.isEmpty((CharSequence)videoHeightStr) ? 0 : Integer.parseInt(videoHeightStr);
        }
        if (videoDuration < 1) {
            int n = videoDuration = TextUtils.isEmpty((CharSequence)durationString) ? 0 : Integer.parseInt(durationString);
        }
        if (videoSize < 1L) {
            videoSize = videoFile.length();
        }
        return new Video(videoPath, videoSize, videoWidth, videoHeight, videoDuration, coverPath, coverWidth, coverHeight);
    }

    @Override
    public Error validContent() {
        File file;
        if (TextUtils.isEmpty((CharSequence)this.videoUrl)) {
            return new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Parameter");
        }
        if (this.coverHeight < 0 || this.coverWidth < 0 || this.videoWidth < 0 || this.videoHeight < 0 || this.videoSize < 0L || this.videoDuration < 0) {
            return new Error(ErrorEnum.INVALID_PARAMETER, "Invalid Parameter");
        }
        if (FileUtils.isNotWebUrl(this.videoUrl)) {
            file = new File(this.videoUrl);
            if (file.length() > 0x3200000L) {
                return new Error(ErrorEnum.MSG_SIZE_LIMIT_EXCEEDED, "Content Size Limit");
            }
            if (!FileUtils.validVideoType(this.videoUrl)) {
                return new Error(ErrorEnum.INVALID_PARAMETER, "Content Format Error");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.coverUrl) && FileUtils.isNotWebUrl(this.coverUrl)) {
            file = new File(this.coverUrl);
            if (file.length() > 0x1400000L) {
                return new Error(ErrorEnum.MSG_SIZE_LIMIT_EXCEEDED, "Content Size Limit");
            }
            if (!FileUtils.validImageType(file)) {
                return new Error(ErrorEnum.INVALID_PARAMETER, "Content Format Error");
            }
        }
        return null;
    }

    public String getVideoUrl() {
        return this.videoUrl;
    }

    public long getVideoSize() {
        return this.videoSize;
    }

    public int getVideoDuration() {
        return this.videoDuration;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public String getCoverUrl() {
        return this.coverUrl;
    }

    public String getCoverThumbUrl() {
        return this.coverThumbUrl;
    }

    public void setCoverThumbUrl(String coverThumbUrl) {
        this.coverThumbUrl = coverThumbUrl;
    }

    public int getCoverWidth() {
        return this.coverWidth;
    }

    public int getCoverHeight() {
        return this.coverHeight;
    }

    public String toString() {
        String toStr = "videoUrl='" + this.videoUrl + '\'' + ", videoSize=" + this.videoSize + ", videoDuration=" + this.videoDuration + ", videoWidth=" + this.videoWidth + ", videoHeight=" + this.videoHeight + ", coverUrl='" + this.coverUrl + '\'' + ", coverThumbUrl='" + this.coverThumbUrl + '\'' + ", coverWidth=" + this.coverWidth + ", coverHeight=" + this.coverHeight;
        if (this.getProgress() != null) {
            toStr = toStr + ", " + this.getProgress();
        }
        return String.format(Locale.US, "Video{%s}", toStr);
    }

    public static void registerCodecs() {
        Video.registerCodec(new Content.Codec(){
            static final String KEY_VIDEO_URL = "video_url";
            static final String KEY_VIDEO_SIZE = "video_size";
            static final String KEY_VIDEO_DURATION = "video_duration";
            static final String KEY_VIDEO_WIDTH = "video_width";
            static final String KEY_VIDEO_HEIGHT = "video_height";
            static final String KEY_COVER_URL = "cover_url";
            static final String KEY_COVER_THUMB = "cover_thumb";
            static final String KEY_COVER_WIDTH = "cover_width";
            static final String KEY_COVER_HEIGHT = "cover_height";

            @Override
            public int type() {
                return 4;
            }

            @Override
            public Class<? extends Content> contentClass() {
                return Video.class;
            }

            @Override
            public String makeDBString(Content content) throws Throwable {
                Video video = (Video)content;
                JSONObject json = new JSONObject();
                json.put(KEY_VIDEO_URL, (Object)video.videoUrl);
                json.put(KEY_VIDEO_SIZE, video.videoSize);
                json.put(KEY_VIDEO_DURATION, video.videoDuration);
                json.put(KEY_VIDEO_WIDTH, video.videoWidth);
                json.put(KEY_VIDEO_HEIGHT, video.videoHeight);
                json.put(KEY_COVER_URL, (Object)video.coverUrl);
                if (!TextUtils.isEmpty((CharSequence)video.coverThumbUrl)) {
                    json.put(KEY_COVER_THUMB, (Object)video.coverThumbUrl);
                }
                json.put(KEY_COVER_WIDTH, video.coverWidth);
                json.put(KEY_COVER_HEIGHT, video.coverHeight);
                return json.toString();
            }

            @Override
            public Content makeChatContent(String data) throws Throwable {
                JSONObject json = new JSONObject(data);
                Video video = new Video(json.getString(KEY_VIDEO_URL), json.getInt(KEY_VIDEO_SIZE), json.getInt(KEY_VIDEO_DURATION), json.getInt(KEY_VIDEO_WIDTH), json.getInt(KEY_VIDEO_HEIGHT), json.getString(KEY_COVER_URL), json.getInt(KEY_COVER_WIDTH), json.getInt(KEY_COVER_HEIGHT));
                if (json.has(KEY_COVER_THUMB)) {
                    video.coverThumbUrl = json.getString(KEY_COVER_THUMB);
                }
                return video;
            }

            public String toString() {
                return "VideoCodec";
            }
        });
    }
}

