/*
 * Decompiled with CFR 0.152.
 */
package com.hummer.im.model.chat.contents;

import com.hummer.im.Error;
import com.hummer.im.ErrorEnum;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.log.Trace;
import com.hummer.im.model.chat.Content;
import java.nio.charset.Charset;

public final class Text
extends Content {
    public static final int TYPE = 0;
    private final String text;

    public Text(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public Error validContent() {
        if (this.text != null && this.text.getBytes(Charset.forName("UTF-8")).length > 32768) {
            return new Error(ErrorEnum.MSG_SIZE_LIMIT_EXCEEDED, "Content Size Limit");
        }
        return null;
    }

    public String toString() {
        return "Text{" + this.getText() + "}";
    }

    public static void registerCodecs() {
        Text.registerCodec(new Content.Codec(){

            @Override
            public int type() {
                return 0;
            }

            @Override
            public Class<? extends Content> contentClass() {
                return Text.class;
            }

            @Override
            public Content makeChatContent(String data) {
                return new Text(data);
            }

            @Override
            public String makeDBString(Content content) {
                if (!(content instanceof Text)) {
                    Log.e("Text", Trace.method("makeDBString").info("content", content));
                    return null;
                }
                return ((Text)content).getText();
            }

            public String toString() {
                return "TextCodec";
            }
        });
    }
}

